/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.CremaSupport;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.interpreter.BuildTimeInterpreterUniverse;
import com.oracle.svm.interpreter.CremaSupportImpl;
import com.oracle.svm.interpreter.InterpreterFeature;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;

@Platforms(value={Platform.HOSTED_ONLY.class})
@AutomaticallyRegisteredFeature
public class CremaFeature
implements InternalFeature {
    private Method enterVTableInterpreterStub;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return RuntimeClassLoading.isSupported();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(InterpreterFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(CremaSupport.class, (Object)new CremaSupportImpl());
        VMError.guarantee(!RuntimeClassLoading.isSupported() || ClassForNameSupport.respectClassLoader());
    }

    private static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError((Object)"Enabling assertions");
            }
        }
        return enabled;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        try {
            this.enterVTableInterpreterStub = InterpreterStubSection.class.getMethod("enterVTableInterpreterStub", Integer.TYPE, Pointer.class);
            accessImpl.registerAsRoot(this.enterVTableInterpreterStub, true, "stub for interpreter", new MultiMethod.MultiMethodKey[0]);
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        AnalysisUniverse aUniverse = ((FeatureImpl.AfterAnalysisAccessImpl)access).getUniverse();
        BuildTimeInterpreterUniverse btiUniverse = BuildTimeInterpreterUniverse.singleton();
        if (CremaFeature.assertionsEnabled()) {
            for (AnalysisType analysisType : aUniverse.getTypes()) {
                if (analysisType.isReachable()) assert (btiUniverse.getOrCreateType((ResolvedJavaType)analysisType) != null) : "type is reachable but not part of interpreter universe: " + String.valueOf(analysisType);
            }
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl accessImpl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        HostedUniverse hUniverse = accessImpl.getUniverse();
        BuildTimeInterpreterUniverse iUniverse = BuildTimeInterpreterUniverse.singleton();
        Field vtableHolderField = ReflectionUtil.lookupField(InterpreterResolvedObjectType.class, (String)"vtableHolder");
        for (HostedType hType : hUniverse.getTypes()) {
            iUniverse.mirrorSVMVTable(hType, objectType -> accessImpl.getHeapScanner().rescanField(objectType, vtableHolderField));
        }
    }

    @Override
    public void afterAbstractImageCreation(InternalFeature.AfterAbstractImageCreationAccess access) {
        FeatureImpl.AfterAbstractImageCreationAccessImpl accessImpl = (FeatureImpl.AfterAbstractImageCreationAccessImpl)access;
        InterpreterStubSection stubSection = (InterpreterStubSection)ImageSingletons.lookup(InterpreterStubSection.class);
        stubSection.createInterpreterVTableEnterStubSection(accessImpl.getImage());
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        FeatureImpl.BeforeImageWriteAccessImpl accessImpl = (FeatureImpl.BeforeImageWriteAccessImpl)access;
        InterpreterStubSection stubSection = (InterpreterStubSection)ImageSingletons.lookup(InterpreterStubSection.class);
        stubSection.markEnterStubPatch(accessImpl.getHostedMetaAccess().lookupJavaMethod(this.enterVTableInterpreterStub));
    }
}

