/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;

public class DiffTool {
    public static <T> List<DiffResult<T>> diffResults(List<T> left, List<T> right) {
        return DiffTool.diffResults(left, right, Object::equals);
    }

    public static <T> List<DiffResult<T>> diffResults(List<T> left, List<T> right, BiPredicate<T, T> equality) {
        int[][] length = DiffTool.buildLCSLength(left, right, equality);
        ArrayList<DiffResult<T>> result = new ArrayList<DiffResult<T>>();
        DiffTool.generateDiff(length, left, right, left.size(), right.size(), equality, result);
        return result;
    }

    private static <T> int[][] buildLCSLength(List<T> left, List<T> right, BiPredicate<T, T> equality) {
        int[][] length = new int[left.size() + 1][right.size() + 1];
        for (int leftIndex = 0; leftIndex < left.size(); ++leftIndex) {
            for (int rightIndex = 0; rightIndex < right.size(); ++rightIndex) {
                length[leftIndex + 1][rightIndex + 1] = equality.test(left.get(leftIndex), right.get(rightIndex)) ? length[leftIndex][rightIndex] + 1 : Math.max(length[leftIndex + 1][rightIndex], length[leftIndex][rightIndex + 1]);
            }
        }
        return length;
    }

    private static <T> void generateDiff(int[][] length, List<T> left, List<T> right, int leftIndex, int rightIndex, BiPredicate<T, T> equality, List<DiffResult<T>> result) {
        if (leftIndex > 0 && rightIndex > 0 && equality.test(left.get(leftIndex - 1), right.get(rightIndex - 1))) {
            DiffTool.generateDiff(length, left, right, leftIndex - 1, rightIndex - 1, equality, result);
            result.add(new DiffResult(DiffResult.Kind.Equal, leftIndex - 1));
        } else if (rightIndex > 0 && (leftIndex == 0 || length[leftIndex][rightIndex - 1] >= length[leftIndex - 1][rightIndex])) {
            DiffTool.generateDiff(length, left, right, leftIndex, rightIndex - 1, equality, result);
            result.add(new DiffResult(DiffResult.Kind.Added, rightIndex - 1));
        } else if (leftIndex > 0 && (rightIndex == 0 || length[leftIndex][rightIndex - 1] < length[leftIndex - 1][rightIndex])) {
            DiffTool.generateDiff(length, left, right, leftIndex - 1, rightIndex, equality, result);
            result.add(new DiffResult(DiffResult.Kind.Removed, leftIndex - 1));
        }
    }

    public record DiffResult<T>(Kind kind, int index) {
        public String toString(List<T> left, List<T> right) {
            return (switch (this.kind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> " ";
                case 1 -> "+";
                case 2 -> "-";
            }) + String.valueOf(this.getEntry(left, right));
        }

        public T getEntry(List<T> left, List<T> right) {
            List<T> holder = switch (this.kind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> left;
                case 1 -> right;
            };
            return holder.get(this.index);
        }

        @Override
        public String toString() {
            String string = String.valueOf((Object)this.kind);
            return string + " on " + (switch (this.kind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> "left";
                case 1 -> "right";
            }) + " Index=" + this.index;
        }

        public static enum Kind {
            Equal,
            Added,
            Removed;

        }
    }
}

