/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.nodes.SubstrateIndirectCallTargetNode;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.reflect.ReflectionGraphKit;
import java.lang.reflect.Executable;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class ReflectionExpandSignatureMethod
extends NonBytecodeMethod {
    private final boolean isStatic;
    private final Class<?>[] argTypes;
    private final JavaKind returnKind;
    private final boolean callerSensitiveAdapter;
    private final Executable member;

    public ReflectionExpandSignatureMethod(String name, ResolvedJavaMethod prototype, boolean isStatic, Class<?>[] argTypes, JavaKind returnKind, boolean callerSensitiveAdapter, Executable member) {
        super(name, true, prototype.getDeclaringClass(), prototype.getSignature(), prototype.getConstantPool());
        this.isStatic = isStatic;
        this.argTypes = argTypes;
        this.returnKind = returnKind;
        this.callerSensitiveAdapter = callerSensitiveAdapter;
        this.member = member;
    }

    public StructuredGraph buildGraph(DebugContext ctx, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        InvokeWithExceptionNode returnValue;
        ReflectionGraphKit kit = new ReflectionGraphKit(ctx, providers, (ResolvedJavaMethod)method);
        ValueNode receiver = kit.loadLocal(0, JavaKind.Object);
        ValueNode argumentArray = kit.loadLocal(1, JavaKind.Object);
        ValueNode invokedMethod = kit.loadLocal(2, JavaKind.Object);
        ValueNode callerClass = this.callerSensitiveAdapter ? kit.loadLocal(3, JavaKind.Object) : null;
        kit.getFrameState().clearLocals();
        int receiverOffset = this.isStatic ? 0 : 1;
        int argsCount = this.argTypes.length + receiverOffset + (this.callerSensitiveAdapter ? 1 : 0);
        ValueNode[] args = new ValueNode[argsCount];
        ResolvedJavaType[] signature = new ResolvedJavaType[argsCount];
        if (!this.isStatic) {
            signature[0] = kit.getMetaAccess().lookupJavaType(Object.class);
            args[0] = receiver;
        }
        if (this.callerSensitiveAdapter) {
            signature[argsCount - 1] = kit.getMetaAccess().lookupJavaType(Class.class);
            args[argsCount - 1] = callerClass;
        }
        kit.fillArgsArray(argumentArray, receiverOffset, args, this.argTypes);
        for (int i = 0; i < this.argTypes.length; ++i) {
            signature[i + receiverOffset] = kit.getMetaAccess().lookupJavaType(this.argTypes[i]);
        }
        CallTargetNode callTarget = (CallTargetNode)kit.append((Node)new SubstrateIndirectCallTargetNode(invokedMethod, args, StampPair.createSingle((Stamp)StampFactory.forKind((JavaKind)this.returnKind)), (JavaType[])signature, null, SubstrateCallingConventionKind.Java.toType(true), CallTargetNode.InvokeKind.Static));
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(callTarget, kit.getFrameState(), kit.bci());
        kit.exceptionPart();
        kit.branchToInvocationTargetException(kit.exceptionObject());
        kit.endInvokeWithException();
        if (this.returnKind == JavaKind.Void) {
            returnValue = kit.createObject(null);
        } else {
            returnValue = invoke;
            if (this.returnKind.isPrimitive()) {
                AnalysisType boxedRetType = kit.getMetaAccess().lookupJavaType(this.returnKind.toBoxedJavaClass());
                returnValue = kit.createBoxing((ValueNode)returnValue, this.returnKind, (ResolvedJavaType)boxedRetType);
            }
        }
        kit.createReturn((ValueNode)returnValue, JavaKind.Object);
        kit.emitIllegalArgumentException(this.isStatic ? null : receiver, argumentArray);
        kit.emitInvocationTargetException();
        return kit.finalizeGraph();
    }

    public Executable getMember() {
        return this.member;
    }
}

