/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.util.TypeResult;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class NativeImageConditionResolver
implements ConfigurationConditionResolver<ConfigurationCondition> {
    private final ImageClassLoader classLoader;
    private final ClassInitializationSupport classInitializationSupport;

    public NativeImageConditionResolver(ImageClassLoader classLoader, ClassInitializationSupport classInitializationSupport) {
        this.classLoader = classLoader;
        this.classInitializationSupport = classInitializationSupport;
    }

    public TypeResult<ConfigurationCondition> resolveCondition(UnresolvedConfigurationCondition unresolvedCondition) {
        String reflectionName = ClassNameSupport.typeNameToReflectionName((String)unresolvedCondition.getTypeName());
        TypeResult<Class<?>> clazz = this.classLoader.findClass(reflectionName);
        return clazz.map(type -> {
            boolean runtimeChecked = !this.classInitializationSupport.isAlwaysReached((Class<?>)type) && unresolvedCondition.isRuntimeChecked();
            return ConfigurationCondition.create((Class)type, (boolean)runtimeChecked);
        });
    }

    public ConfigurationCondition alwaysTrue() {
        return ConfigurationCondition.alwaysTrue();
    }
}

