/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.hosted.image.MethodPointerRelocationProvider;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.PLTSectionSupport;
import java.util.function.Predicate;

public class PLTGOTPointerRelocationProvider
extends MethodPointerRelocationProvider {
    private final Predicate<SharedMethod> shouldMarkRelocationToPLTStub;
    private final PLTSectionSupport pltSectionSupport;

    public PLTGOTPointerRelocationProvider(Predicate<SharedMethod> shouldMarkRelocationToPLTStub) {
        this.shouldMarkRelocationToPLTStub = shouldMarkRelocationToPLTStub;
        this.pltSectionSupport = HostedPLTGOTConfiguration.singleton().getPLTSectionSupport();
    }

    @Override
    public void markMethodPointerRelocation(ObjectFile.ProgbitsSectionImpl section, int offset, ObjectFile.RelocationKind relocationKind, HostedMethod target, long addend, MethodPointer methodPointer, boolean isInjectedNotCompiled) {
        if (methodPointer.permitsRewriteToPLT() && this.shouldMarkRelocationToPLTStub.test(target)) {
            this.pltSectionSupport.markRelocationToPLTStub(section, offset, relocationKind, target, addend);
        } else {
            super.markMethodPointerRelocation(section, offset, relocationKind, target, addend, methodPointer, isInjectedNotCompiled);
        }
    }
}

