/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.pltgot.GOTAccess;
import com.oracle.svm.core.pltgot.PLTGOTConfiguration;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.MethodPointerRelocationProvider;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.pltgot.CollectPLTGOTCallSitesResolutionSupport;
import com.oracle.svm.hosted.pltgot.GOTEntryAllocator;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.MethodAddressResolutionSupport;
import com.oracle.svm.hosted.pltgot.PLTGOTOptions;
import com.oracle.svm.hosted.pltgot.PLTGOTPointerRelocationProvider;
import com.oracle.svm.hosted.pltgot.PLTSectionSupport;
import com.oracle.svm.hosted.pltgot.aarch64.AArch64HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.amd64.AMD64HostedPLTGOTConfiguration;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

public class PLTGOTFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return PLTGOTOptions.EnablePLTGOT.getValue();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        VMError.guarantee(Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class) || Platform.includedIn(Platform.WINDOWS.class), "PLT and GOT is currently only supported on Linux, Darwin and Windows.");
        VMError.guarantee(Platform.includedIn(Platform.AARCH64.class) || Platform.includedIn(Platform.AMD64.class), "PLT and GOT is currently only supported on AArch64 and AMD64.");
        VMError.guarantee(!RuntimeCompilation.isEnabled(), "PLT and GOT is currently not supported with runtime compilation.");
        VMError.guarantee(SubstrateOptions.SpawnIsolates.getValue(), "PLT and GOT cannot work without isolates.");
        VMError.guarantee("lir".equals(SubstrateOptions.CompilerBackend.getValue()), "PLT and GOT cannot work with a custom compiler backend.");
        ImageSingletons.add(PLTGOTConfiguration.class, (Object)PLTGOTFeature.createConfiguration());
    }

    private static PLTGOTConfiguration createConfiguration() {
        if (Platform.includedIn(Platform.AMD64.class)) {
            return new AMD64HostedPLTGOTConfiguration();
        }
        if (Platform.includedIn(Platform.AARCH64.class)) {
            return new AArch64HostedPLTGOTConfiguration();
        }
        throw VMError.shouldNotReachHere("PLT and GOT is currently only supported on AArch64 and AMD64.");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Method resolver = HostedPLTGOTConfiguration.singleton().getArchSpecificResolverAsMethod();
        ((FeatureImpl.BeforeAnalysisAccessImpl)access).registerAsRoot(resolver, false, "PLT GOT support, registered in " + String.valueOf(PLTGOTFeature.class), new MultiMethod.MultiMethodKey[0]);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        HostedPLTGOTConfiguration.singleton().setHostedMetaAccess(((FeatureImpl.BeforeCompilationAccessImpl)access).getMetaAccess());
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        MethodAddressResolutionSupport methodAddressResolutionSupport = HostedPLTGOTConfiguration.singleton().getMethodAddressResolutionSupport();
        GOTEntryAllocator gotEntryAllocator = HostedPLTGOTConfiguration.singleton().getGOTEntryAllocator();
        gotEntryAllocator.reserveAndLayout(((FeatureImpl.AfterCompilationAccessImpl)access).getCompilations().keySet(), methodAddressResolutionSupport);
        Set<SharedMethod> gotTable = Set.of(gotEntryAllocator.getGOT());
        ImageSingletons.add(MethodPointerRelocationProvider.class, (Object)new PLTGOTPointerRelocationProvider(gotTable::contains));
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        HostedPLTGOTConfiguration.singleton().markResolverMethodPatch();
        if (PLTGOTOptions.PrintPLTGOTCallsInfo.getValue().booleanValue()) {
            PLTGOTFeature.reportPLTGOTCallSites();
        }
    }

    @Override
    public void afterAbstractImageCreation(InternalFeature.AfterAbstractImageCreationAccess access) {
        FeatureImpl.AfterAbstractImageCreationAccessImpl accessImpl = (FeatureImpl.AfterAbstractImageCreationAccessImpl)access;
        ObjectFile imageObjectFile = accessImpl.getImage().getObjectFile();
        SharedMethod[] got = HostedPLTGOTConfiguration.singleton().getGOTEntryAllocator().getGOT();
        PLTSectionSupport pltSectionSupport = HostedPLTGOTConfiguration.singleton().getPLTSectionSupport();
        pltSectionSupport.createPLTSection(got, imageObjectFile, accessImpl.getSubstrateBackend());
        PLTGOTFeature.createGOTSection(got, imageObjectFile, pltSectionSupport);
        HostedPLTGOTConfiguration.singleton().getMethodAddressResolutionSupport().augmentImageObjectFile(imageObjectFile);
    }

    public static void createGOTSection(SharedMethod[] got, ObjectFile objectFile, PLTSectionSupport pltSectionSupport) {
        int wordSize = ConfigurationValues.getTarget().wordSize;
        int gotSectionSize = got.length * wordSize;
        RelocatableBuffer gotBuffer = new RelocatableBuffer(gotSectionSize, objectFile.getByteOrder());
        BasicProgbitsSectionImpl gotBufferImpl = new BasicProgbitsSectionImpl(gotBuffer.getBackingArray());
        String name = HostedPLTGOTConfiguration.SVM_GOT_SECTION.getFormatDependentName(objectFile.getFormat());
        ObjectFile.Section gotSection = objectFile.newProgbitsSection(name, objectFile.getPageSize(), true, false, (ObjectFile.ProgbitsSectionImpl)gotBufferImpl);
        ObjectFile.RelocationKind relocationKind = ObjectFile.RelocationKind.getDirect((int)wordSize);
        for (int gotEntryNo = 0; gotEntryNo < got.length; ++gotEntryNo) {
            int methodGOTEntryOffsetInSection = gotSectionSize + GOTAccess.getGotEntryOffsetFromHeapRegister(gotEntryNo);
            pltSectionSupport.markRelocationToPLTResolverJump((ObjectFile.ProgbitsSectionImpl)gotBufferImpl, methodGOTEntryOffsetInSection, relocationKind, got[gotEntryNo]);
        }
        objectFile.createDefinedSymbol(gotSection.getName(), (ObjectFile.Element)gotSection, 0L, 0, false, false);
        objectFile.createDefinedSymbol("__svm_got_begin", (ObjectFile.Element)gotSection, 0L, wordSize, false, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
        objectFile.createDefinedSymbol("__svm_got_end", (ObjectFile.Element)gotSection, (long)gotSectionSize, wordSize, false, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
        if (PLTGOTOptions.PrintGOT.getValue().booleanValue()) {
            ReportUtils.report((String)"GOT Section contents", (String)SubstrateOptions.reportsPath(), (String)"got", (String)"txt", writer -> {
                writer.println("GOT Entry No | GOT Entry Offset From Image Heap Register | Method Name");
                for (int i = 0; i < got.length; ++i) {
                    writer.printf("%5X %5X %s%n", i, -GOTAccess.getGotEntryOffsetFromHeapRegister(i), got[i].toString());
                }
            });
        }
    }

    private static void reportPLTGOTCallSites() {
        CollectPLTGOTCallSitesResolutionSupport resolver = (CollectPLTGOTCallSitesResolutionSupport)HostedPLTGOTConfiguration.singleton().getMethodAddressResolutionSupport();
        Consumer<PrintWriter> reportWriter = pw -> {
            String methodFormat = "%H.%n(%p)";
            try (JsonWriter writer = new JsonWriter((Writer)pw);){
                writer.append('{').newline();
                List<String> calleesWithUnknownCaller = resolver.getCalleesWithUnknownCaller().stream().map(m -> m.format("%H.%n(%p)")).toList();
                if (!calleesWithUnknownCaller.isEmpty()) {
                    writer.quote("UNKNOWN_CALLER").append(":[").indent().newline();
                    PLTGOTFeature.appendCallees(writer, calleesWithUnknownCaller.iterator());
                    writer.newline().unindent().append("]");
                }
                for (Map.Entry<HostedMethod, Set<HostedMethod>> entry : resolver.getCallerCalleesMap().entrySet()) {
                    writer.append(',').newline();
                    HostedMethod caller = entry.getKey();
                    Iterator<String> calleesIter = entry.getValue().stream().map(m -> m.format("%H.%n(%p)")).sorted().iterator();
                    writer.quote(caller.format("%H.%n(%p)")).append(":[").indent().newline();
                    PLTGOTFeature.appendCallees(writer, calleesIter);
                    writer.unindent().newline().append(']');
                }
                writer.newline().append('}').newline();
            }
            catch (IOException e) {
                VMError.shouldNotReachHere(e);
            }
        };
        ReportUtils.report((String)"PLT/GOT call-sites info", (String)SubstrateOptions.reportsPath(), (String)"plt_got_call-sites_info", (String)"json", reportWriter);
    }

    private static void appendCallees(JsonWriter writer, Iterator<String> callees) throws IOException {
        while (callees.hasNext()) {
            String callee = callees.next();
            writer.quote(callee);
            if (!callees.hasNext()) continue;
            writer.append(',');
            writer.newline();
        }
    }
}

