/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.phases.EnumSwitchFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;

final class EnumSwitchPlugin
implements NodePlugin {
    private static final String METHOD_NAME_PREFIX = "$SWITCH_TABLE$";
    private final ParsingReason reason;

    EnumSwitchPlugin(ParsingReason reason) {
        this.reason = reason;
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod m, ValueNode[] args) {
        Object switchTable;
        VMError.guarantee(this.reason.duringAnalysis(), "plugin can only be used during parsing for analysis");
        AnalysisMethod method = (AnalysisMethod)m;
        if (!method.getName().startsWith(METHOD_NAME_PREFIX) || !method.isStatic() || method.getSignature().getParameterCount(false) != 0) {
            return false;
        }
        if (!method.getDeclaringClass().isInitialized()) {
            return false;
        }
        EnumSwitchFeature feature = (EnumSwitchFeature)ImageSingletons.lookup(EnumSwitchFeature.class);
        method.ensureGraphParsed(feature.getBigBang());
        Boolean methodSafeForExecution = feature.isMethodsSafeForExecution(method);
        assert (methodSafeForExecution != null) : "after-parsing hook not executed for method " + method.format("%H.%n(%p)");
        if (!methodSafeForExecution.booleanValue()) {
            return false;
        }
        try {
            Method switchTableMethod = ReflectionUtil.lookupMethod((Class)method.getDeclaringClass().getJavaClass(), (String)method.getName(), (Class[])new Class[0]);
            switchTable = switchTableMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw GraalError.shouldNotReachHere((Throwable)ex);
        }
        if (switchTable instanceof int[]) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject(switchTable), (int)1, (boolean)true, (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        return false;
    }
}

