/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredDispatchTableFeature;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import jdk.graal.compiler.debug.Assertions;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;

public final class VTableBuilder {
    private final HostedUniverse hUniverse;
    private final HostedMetaAccess hMetaAccess;
    private final OpenTypeWorldHubLayoutUtils openHubUtils;

    private VTableBuilder(HostedUniverse hUniverse, HostedMetaAccess hMetaAccess) {
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
        this.openHubUtils = SubstrateOptions.useClosedTypeWorldHubLayout() ? null : new OpenTypeWorldHubLayoutUtils(hUniverse);
    }

    public static void buildTables(HostedUniverse hUniverse, HostedMetaAccess hMetaAccess) {
        VTableBuilder builder = new VTableBuilder(hUniverse, hMetaAccess);
        if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
            builder.buildClosedTypeWorldVTables();
        } else {
            builder.buildOpenTypeWorldDispatchTables();
            assert (builder.verifyOpenTypeWorldDispatchTables());
        }
    }

    private boolean verifyOpenTypeWorldDispatchTables() {
        HostedMethod invalidVTableEntryHandler = this.hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        for (HostedType type : this.hUniverse.getTypes()) {
            if (!type.isInstantiated()) continue;
            for (int i = 0; i < type.openTypeWorldDispatchTableSlotTargets.length; ++i) {
                HostedMethod slotMethod = type.openTypeWorldDispatchTableSlotTargets[i];
                HostedMethod resolvedMethod = (HostedMethod)type.resolveConcreteMethod(slotMethod, type);
                if (resolvedMethod == null) {
                    resolvedMethod = invalidVTableEntryHandler;
                }
                HostedMethod tableResolvedMethod = type.openTypeWorldDispatchTables[i];
                assert (tableResolvedMethod.equals(resolvedMethod)) : Assertions.errorMessage((Object[])new Object[]{type, slotMethod, tableResolvedMethod, resolvedMethod});
                if (slotMethod.getDeclaringClass().isInterface()) {
                    int interfaceTypeID = slotMethod.getDeclaringClass().getTypeID();
                    int[] typeCheckSlots = type.getOpenTypeWorldTypeCheckSlots();
                    boolean found = false;
                    for (int itableIdx = 0; itableIdx < type.getNumInterfaceTypes(); ++itableIdx) {
                        if (typeCheckSlots[type.getNumClassTypes() + itableIdx] != interfaceTypeID) continue;
                        HostedMethod dispatchResult = type.openTypeWorldDispatchTables[type.itableStartingOffsets[itableIdx] + slotMethod.getVTableIndex()];
                        assert (dispatchResult.equals(resolvedMethod)) : Assertions.errorMessage((Object[])new Object[]{slotMethod, dispatchResult, resolvedMethod});
                        found = true;
                        break;
                    }
                    assert (found) : Assertions.errorMessage((Object[])new Object[]{slotMethod, type, resolvedMethod});
                    continue;
                }
                HostedMethod openTypeWorldMethod = type.openTypeWorldDispatchTables[slotMethod.getVTableIndex()];
                assert (openTypeWorldMethod.equals(resolvedMethod)) : Assertions.errorMessage((Object[])new Object[]{slotMethod, openTypeWorldMethod, resolvedMethod});
            }
        }
        return true;
    }

    private List<HostedMethod> generateITable(HostedType type) {
        return this.generateDispatchTable(type, 0);
    }

    private List<HostedMethod> generateDispatchTable(HostedType type, int startingIndex) {
        Predicate<HostedMethod> includeMethod = this.openHubUtils.filterVTableMethods(type) ? m -> {
            assert (!m.isConstructor()) : Assertions.errorMessage((Object[])new Object[]{"Constructors should never be in dispatch tables", m});
            if (m.implementations.length > 1) {
                return true;
            }
            if (m.wrapped.isVirtualRootMethod()) {
                return !m.canBeStaticallyBound();
            }
            return false;
        } : m -> {
            assert (!m.isConstructor()) : Assertions.errorMessage((Object[])new Object[]{"Constructors should never be in dispatch tables", m});
            return !m.getWrapped().canBeStaticallyBound();
        };
        List<HostedMethod> table = type.getWrapped().getOpenTypeWorldDispatchTableMethods().stream().map(this.hUniverse::lookup).filter(includeMethod).sorted(HostedUniverse.METHOD_COMPARATOR).toList();
        int index = startingIndex;
        for (HostedMethod typeMethod : table) {
            assert (typeMethod.getDeclaringClass().equals(type)) : typeMethod;
            assert (typeMethod.vtableIndex == -1) : typeMethod.vtableIndex;
            typeMethod.vtableIndex = index++;
        }
        if (this.openHubUtils.shouldRegisterType(type)) {
            LayeredDispatchTableFeature.singleton().registerDeclaredDispatchInfo(type, table);
        }
        return table;
    }

    private void generateOpenTypeWorldDispatchTable(HostedInstanceClass type, Map<HostedType, List<HostedMethod>> dispatchTablesMap, HostedMethod invalidDispatchTableEntryHandler) {
        List<HostedMethod> resultClassTableMethods;
        HostedClass superClass = type.getSuperclass();
        List<HostedMethod> parentClassTable = superClass == null ? List.of() : dispatchTablesMap.get(superClass);
        List<HostedMethod> classTableWithoutSuper = this.generateDispatchTable(type, parentClassTable.size());
        if (!classTableWithoutSuper.isEmpty()) {
            resultClassTableMethods = new ArrayList(parentClassTable);
            resultClassTableMethods.addAll(classTableWithoutSuper);
        } else {
            resultClassTableMethods = parentClassTable;
        }
        dispatchTablesMap.put(type, resultClassTableMethods);
        if (!type.isAbstract()) {
            ArrayList<HostedMethod> aggregatedTable = new ArrayList<HostedMethod>(resultClassTableMethods);
            HostedType[] interfaces = type.typeCheckInterfaceOrder;
            type.itableStartingOffsets = new int[interfaces.length];
            int currentITableOffset = resultClassTableMethods.size();
            for (int i = 0; i < interfaces.length; ++i) {
                HostedType interfaceType = interfaces[i];
                List<HostedMethod> interfaceMethods = dispatchTablesMap.get(interfaceType);
                type.itableStartingOffsets[i] = currentITableOffset;
                aggregatedTable.addAll(interfaceMethods);
                currentITableOffset += interfaceMethods.size();
            }
            type.openTypeWorldDispatchTables = new HostedMethod[aggregatedTable.size()];
            type.openTypeWorldDispatchTableSlotTargets = (HostedMethod[])aggregatedTable.toArray(HostedMethod[]::new);
            boolean[] validTarget = new boolean[aggregatedTable.size()];
            for (int i = 0; i < aggregatedTable.size(); ++i) {
                HostedMethod method = (HostedMethod)aggregatedTable.get(i);
                HostedMethod targetMethod = invalidDispatchTableEntryHandler;
                if (type.isInstantiated()) {
                    HostedMethod indirectCallTarget;
                    HostedMethod resolvedMethod = (HostedMethod)type.resolveConcreteMethod(method, type);
                    if (resolvedMethod != null) {
                        targetMethod = resolvedMethod;
                        validTarget[i] = true;
                    }
                    if (SubstrateUtil.assertionsEnabled() && !(indirectCallTarget = this.hUniverse.lookup((JavaMethod)method.getWrapped().getIndirectCallTarget())).equals(method)) {
                        boolean condition;
                        HostedMethod resolvedIndirectCallTarget = (HostedMethod)type.resolveConcreteMethod(indirectCallTarget, type);
                        boolean bl = condition = resolvedMethod == null && resolvedIndirectCallTarget == null || resolvedMethod != null && resolvedMethod.equals(resolvedIndirectCallTarget);
                        assert (condition) : Assertions.errorMessage((Object[])new Object[]{"Mismatch in method and normal call", method, indirectCallTarget});
                    }
                }
                type.openTypeWorldDispatchTables[i] = targetMethod;
            }
            if (this.openHubUtils.shouldRegisterType(type)) {
                LayeredDispatchTableFeature.singleton().registerNonArrayDispatchTable(type, validTarget);
            }
        }
        for (HostedType subType : type.subTypes) {
            if (!(subType instanceof HostedInstanceClass)) continue;
            HostedInstanceClass instanceClass = (HostedInstanceClass)subType;
            if (!this.openHubUtils.shouldIncludeType(subType)) continue;
            this.generateOpenTypeWorldDispatchTable(instanceClass, dispatchTablesMap, invalidDispatchTableEntryHandler);
        }
    }

    private void buildOpenTypeWorldDispatchTables() {
        HashMap<HostedType, List<HostedMethod>> dispatchTablesMap = new HashMap<HostedType, List<HostedMethod>>();
        for (HostedType type : this.hUniverse.getTypes()) {
            if (!type.isInterface() || !this.openHubUtils.shouldIncludeType(type)) continue;
            dispatchTablesMap.put(type, this.generateITable(type));
        }
        HostedMethod invalidDispatchTableEntryHandler = this.hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        this.generateOpenTypeWorldDispatchTable((HostedInstanceClass)this.hUniverse.objectType(), dispatchTablesMap, invalidDispatchTableEntryHandler);
        int[] emptyITableOffsets = new int[]{};
        HostedInstanceClass objectType = this.hUniverse.getObjectClass();
        for (HostedType type : this.hUniverse.getTypes()) {
            if (type.isArray() && this.openHubUtils.shouldIncludeType(type)) {
                type.openTypeWorldDispatchTables = objectType.openTypeWorldDispatchTables;
                type.openTypeWorldDispatchTableSlotTargets = objectType.openTypeWorldDispatchTableSlotTargets;
                type.itableStartingOffsets = objectType.itableStartingOffsets;
                if (this.openHubUtils.shouldRegisterType(type)) {
                    LayeredDispatchTableFeature.singleton().registerArrayDispatchTable(type, objectType);
                }
            }
            if (type.openTypeWorldDispatchTables != null) continue;
            assert (!this.openHubUtils.shouldIncludeType(type) || VTableBuilder.hasEmptyDispatchTable(type)) : type;
            type.openTypeWorldDispatchTables = HostedMethod.EMPTY_ARRAY;
            type.openTypeWorldDispatchTableSlotTargets = HostedMethod.EMPTY_ARRAY;
            type.itableStartingOffsets = emptyITableOffsets;
        }
    }

    public static boolean hasEmptyDispatchTable(HostedType type) {
        return (type.isInterface() || type.isPrimitive() || type.isAbstract()) && !type.isArray();
    }

    private void buildClosedTypeWorldVTables() {
        HashMap<HostedType, ArrayList<HostedMethod>> vtablesMap = new HashMap<HostedType, ArrayList<HostedMethod>>();
        HashMap<HostedType, BitSet> usedSlotsMap = new HashMap<HostedType, BitSet>();
        HashMap<HostedMethod, Set<Integer>> vtablesSlots = new HashMap<HostedMethod, Set<Integer>>();
        for (HostedType type : this.hUniverse.getTypes()) {
            vtablesMap.put(type, new ArrayList());
            Iterator initialBitSet = new BitSet();
            usedSlotsMap.put(type, (BitSet)((Object)initialBitSet));
        }
        HostedInstanceClass objectClass = this.hUniverse.getObjectClass();
        this.assignImplementations((HostedType)objectClass, vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<Pair> interfaces = new ArrayList<Pair>();
        for (HostedType type : this.hUniverse.getTypes()) {
            if (!type.isInterface()) continue;
            int importance = VTableBuilder.collectSubtypes(type, new HashSet<HostedType>()).size();
            interfaces.add(Pair.create((Object)type, (Object)importance));
        }
        interfaces.sort((pair1, pair2) -> (Integer)pair2.getRight() - (Integer)pair1.getRight());
        for (Pair pair : interfaces) {
            this.assignImplementations((HostedType)pair.getLeft(), vtablesMap, usedSlotsMap, vtablesSlots);
        }
        this.buildVTable(objectClass, vtablesMap, usedSlotsMap, vtablesSlots);
        HostedMethod invalidVTableEntryHandler = this.hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        for (HostedType type : this.hUniverse.getTypes()) {
            if (type.isArray()) {
                type.closedTypeWorldVTable = objectClass.closedTypeWorldVTable;
            }
            if (type.closedTypeWorldVTable == null || type.closedTypeWorldVTable.length == 0) {
                assert (type.isInterface() || type.isPrimitive() || type.closedTypeWorldVTable.length == 0);
                type.closedTypeWorldVTable = HostedMethod.EMPTY_ARRAY;
            }
            HostedMethod[] vtableArray = type.closedTypeWorldVTable;
            for (int i = 0; i < vtableArray.length; ++i) {
                if (vtableArray[i] != null) continue;
                vtableArray[i] = invalidVTableEntryHandler;
            }
        }
        if (SubstrateUtil.assertionsEnabled()) {
            for (HostedType type : this.hUniverse.getTypes()) {
                for (HostedMethod m : type.closedTypeWorldVTable) {
                    assert (m.equals(invalidVTableEntryHandler) || m.equals(this.hUniverse.lookup((JavaMethod)type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)m.wrapped, (ResolvedJavaType)type.wrapped))));
                }
            }
        }
    }

    private static Set<HostedType> collectSubtypes(HostedType type, Set<HostedType> allSubtypes) {
        if (allSubtypes.add(type)) {
            for (HostedType subtype : type.subTypes) {
                VTableBuilder.collectSubtypes(subtype, allSubtypes);
            }
        }
        return allSubtypes;
    }

    private void buildVTable(HostedClass clazz, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        this.assignImplementations((HostedType)clazz, vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<HostedMethod> vtable = vtablesMap.get(clazz);
        HostedMethod[] vtableArray = vtable.toArray(new HostedMethod[vtable.size()]);
        assert (vtableArray.length == 0 || vtableArray[vtableArray.length - 1] != null) : "Unnecessary entry at end of vtable";
        clazz.closedTypeWorldVTable = vtableArray;
        for (HostedType subClass : clazz.subTypes) {
            if (subClass.isInterface() || subClass.isArray()) continue;
            this.buildVTable((HostedClass)subClass, vtablesMap, usedSlotsMap, vtablesSlots);
        }
    }

    private void assignImplementations(HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        Predicate<HostedMethod> vtableEntryRequired = hMethod -> {
            if (hMethod.implementations.length > 1) {
                return true;
            }
            if (hMethod.wrapped.isVirtualRootMethod()) {
                return !hMethod.canBeStaticallyBound();
            }
            return false;
        };
        for (HostedMethod method : type.getAllDeclaredMethods()) {
            int slot;
            if (!method.wrapped.isInvoked() && !method.wrapped.isImplementationInvoked() || !vtableEntryRequired.test(method)) continue;
            assert (!method.isConstructor()) : Assertions.errorMessage((Object[])new Object[]{"Constructors should never be in vtables", method});
            method.vtableIndex = slot = this.findSlot(method, vtablesMap, usedSlotsMap, vtablesSlots);
            this.assignImplementations(method.getDeclaringClass(), method, slot, vtablesMap);
        }
    }

    private void assignImplementations(HostedType type, HostedMethod method, int slot, Map<HostedType, ArrayList<HostedMethod>> vtablesMap) {
        if (type.wrapped.isInstantiated()) {
            assert (type.isInstanceClass() && !type.isAbstract() || type.isArray());
            HostedMethod resolvedMethod = this.resolveMethod(type, method);
            if (resolvedMethod != null) {
                ArrayList<HostedMethod> vtable = vtablesMap.get(type);
                if (slot < vtable.size() && vtable.get(slot) != null) {
                    assert (vtable.get(slot).equals(resolvedMethod));
                } else {
                    VTableBuilder.resize(vtable, slot + 1);
                    assert (vtable.get(slot) == null);
                    vtable.set(slot, resolvedMethod);
                }
                resolvedMethod.vtableIndex = slot;
            }
        }
        for (HostedType subtype : type.subTypes) {
            if (subtype.isArray()) continue;
            this.assignImplementations(subtype, method, slot, vtablesMap);
        }
    }

    private HostedMethod resolveMethod(HostedType type, HostedMethod method) {
        AnalysisMethod resolved = type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)method.wrapped, (ResolvedJavaType)type.wrapped);
        if (resolved == null || !resolved.isImplementationInvoked()) {
            return null;
        }
        assert (!resolved.isAbstract());
        return this.hUniverse.lookup((JavaMethod)resolved);
    }

    private static void resize(ArrayList<?> list, int minSize) {
        list.ensureCapacity(minSize);
        while (list.size() < minSize) {
            list.add(null);
        }
    }

    private int findSlot(HostedMethod method, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        if (method.implementations.length > 0) {
            Set<Integer> resultSlots = vtablesSlots.get(method.implementations[0]);
            for (HostedMethod impl : method.implementations) {
                Set<Integer> implSlots = vtablesSlots.get(impl);
                if (implSlots == null) {
                    resultSlots = null;
                    break;
                }
                resultSlots.retainAll(implSlots);
            }
            if (resultSlots != null && !resultSlots.isEmpty()) {
                int resultSlot = Integer.MAX_VALUE;
                for (int slot : resultSlots) {
                    resultSlot = Math.min(resultSlot, slot);
                }
                return resultSlot;
            }
        }
        BitSet usedSlots = new BitSet();
        this.collectUsedSlots(method.getDeclaringClass(), usedSlots, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.collectUsedSlots(impl.getDeclaringClass(), usedSlots, usedSlotsMap);
        }
        int resultSlot = usedSlots.nextClearBit(0);
        this.markSlotAsUsed(resultSlot, method.getDeclaringClass(), vtablesMap, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.markSlotAsUsed(resultSlot, impl.getDeclaringClass(), vtablesMap, usedSlotsMap);
            vtablesSlots.computeIfAbsent(impl, k -> new HashSet()).add(resultSlot);
        }
        return resultSlot;
    }

    private void collectUsedSlots(HostedType type, BitSet usedSlots, Map<HostedType, BitSet> usedSlotsMap) {
        usedSlots.or(usedSlotsMap.get(type));
        for (HostedType sub : type.subTypes) {
            if (sub.isArray()) continue;
            this.collectUsedSlots(sub, usedSlots, usedSlotsMap);
        }
    }

    private void markSlotAsUsed(int resultSlot, HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap) {
        assert (resultSlot >= vtablesMap.get(type).size() || vtablesMap.get(type).get(resultSlot) == null);
        usedSlotsMap.get(type).set(resultSlot);
        for (HostedType sub : type.subTypes) {
            if (sub.isArray()) continue;
            this.markSlotAsUsed(resultSlot, sub, vtablesMap, usedSlotsMap);
        }
    }

    private static class OpenTypeWorldHubLayoutUtils {
        private final boolean closedTypeWorld = SubstrateOptions.useClosedTypeWorld();
        private final boolean registerTrackedTypes;
        private final boolean registerAllTypes;

        OpenTypeWorldHubLayoutUtils(HostedUniverse hUniverse) {
            this.registerTrackedTypes = hUniverse.hostVM().enableTrackAcrossLayers();
            this.registerAllTypes = ImageLayerBuildingSupport.buildingApplicationLayer();
            assert (!this.registerTrackedTypes || !this.registerAllTypes) : "We expect these flags to be mutually exclusive";
            assert ((this.registerTrackedTypes || this.registerAllTypes) == ImageLayerBuildingSupport.buildingImageLayer()) : "Type information must be registered during layered image builds";
        }

        private boolean filterVTableMethods(HostedType type) {
            return this.closedTypeWorld && !type.getWrapped().isInBaseLayer();
        }

        private boolean shouldIncludeType(HostedType type) {
            if (this.closedTypeWorld) {
                if (type.getWrapped().isInBaseLayer()) {
                    return type.getWrapped().isOpenTypeWorldDispatchTableMethodsCalculated();
                }
                return type.getWrapped().isReachable() || type.getWrapped().isInBaseLayer();
            }
            return type.getWrapped().isOpenTypeWorldDispatchTableMethodsCalculated();
        }

        private boolean shouldRegisterType(HostedType type) {
            if (this.registerAllTypes) {
                return true;
            }
            return this.registerTrackedTypes && type.getWrapped().isTrackedAcrossLayers();
        }
    }
}

