/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import jdk.vm.ci.meta.JavaKind;

public class HostedPrimitiveType
extends HostedType {
    public HostedPrimitiveType(HostedUniverse universe, AnalysisType wrapped, JavaKind kind, JavaKind storageKind) {
        super(universe, wrapped, kind, storageKind, null, HostedInterface.EMPTY_ARRAY);
    }

    public boolean isInterface() {
        assert (!this.wrapped.isInterface());
        return false;
    }

    public boolean isInstanceClass() {
        assert (!this.wrapped.isInstanceClass());
        return false;
    }

    public boolean isArray() {
        assert (!this.wrapped.isArray());
        return false;
    }

    public boolean isPrimitive() {
        assert (this.wrapped.isPrimitive());
        return true;
    }

    public boolean isEnum() {
        assert (!this.wrapped.isEnum());
        return false;
    }

    @Override
    public final HostedType getComponentType() {
        return null;
    }

    @Override
    public HostedType getBaseType() {
        return this;
    }

    @Override
    public int getArrayDimension() {
        return 0;
    }

    @Override
    public HostedField[] getInstanceFields(boolean includeSuperclasses) {
        return HostedField.EMPTY_ARRAY;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }
}

