/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMemoryAccessProvider;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class HostedConstantReflectionProvider
extends AnalysisConstantReflectionProvider {
    private final HostedUniverse hUniverse;
    private final HostedMetaAccess hMetaAccess;
    private final HostedMemoryAccessProvider hMemoryAccess;

    public HostedConstantReflectionProvider(HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, ClassInitializationSupport classInitializationSupport) {
        super(hUniverse.getBigBang().getUniverse(), (UniverseMetaAccess)hUniverse.getBigBang().getMetaAccess(), classInitializationSupport);
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
        this.hMemoryAccess = new HostedMemoryAccessProvider(hMetaAccess, this);
    }

    @Override
    public MemoryAccessProvider getMemoryAccessProvider() {
        return this.hMemoryAccess;
    }

    @Override
    public ResolvedJavaType asJavaType(Constant constant) {
        return this.hUniverse.lookup((JavaType)super.asJavaType(constant));
    }

    @Override
    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return super.asJavaClass((ResolvedJavaType)((HostedType)type).wrapped);
    }

    @Override
    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        return this.readFieldValue(field, receiver, false);
    }

    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver, boolean readRelocatableValues) {
        HostedField hField = (HostedField)field;
        assert (this.checkHub(receiver)) : "Receiver " + String.valueOf(receiver) + " of field " + String.valueOf(hField) + " read should not be java.lang.Class. Expecting to see DynamicHub here.";
        return super.readValue(hField.getWrapped(), receiver, true, readRelocatableValues);
    }

    private boolean checkHub(JavaConstant constant) {
        if (this.hMetaAccess.isInstanceOf(constant, Class.class)) {
            Object classObject = this.hUniverse.getSnippetReflection().asObject(Object.class, constant);
            return classObject instanceof DynamicHub;
        }
        return true;
    }

    @Override
    public MethodHandleAccessProvider getMethodHandleAccess() {
        throw VMError.shouldNotReachHereAtRuntime();
    }
}

