/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.SharedConstantFieldProvider;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class HostedConstantFieldProvider
extends SharedConstantFieldProvider {
    public HostedConstantFieldProvider(MetaAccessProvider metaAccess, SVMHost hostVM) {
        super(metaAccess, hostVM);
    }

    @Override
    public boolean isFinalField(ResolvedJavaField f, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        HostedField field = (HostedField)f;
        if (HostedConstantFieldProvider.isFinalField(field)) {
            return true;
        }
        return super.isFinalField(field, tool);
    }

    public static boolean isFinalField(HostedField field) {
        if (field.location == -10) {
            return true;
        }
        return !field.isWritten() && field.isValueAvailable();
    }

    @Override
    protected AnalysisField asAnalysisField(ResolvedJavaField field) {
        return ((HostedField)field).getWrapped();
    }
}

