/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class JNIRegistrationManagementExt
extends JNIRegistrationUtil
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JNIRegistrationManagementExt.initializeAtRunTime((Feature.FeatureAccess)access, "com.sun.management.internal.OperatingSystemImpl");
        access.registerReachabilityHandler(this::linkManagementExt, new Object[]{JNIRegistrationManagementExt.clazz((Feature.FeatureAccess)access, "com.sun.management.internal.OperatingSystemImpl")});
        PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_sun_management_internal_OperatingSystemImpl");
    }

    private void linkManagementExt(Feature.DuringAnalysisAccess access) {
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)access).getNativeLibraries();
        nativeLibraries.addStaticNonJniLibrary("management_ext", "java");
        if (JNIRegistrationManagementExt.isWindows()) {
            nativeLibraries.addDynamicNonJniLibrary("psapi");
        }
    }
}

