/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.net.SocketAddress;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
class JNIRegistrationJavaNet
extends JNIRegistrationUtil
implements InternalFeature {
    private boolean hasPlatformSocketOptions;

    JNIRegistrationJavaNet() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        this.hasPlatformSocketOptions = a.findClassByName("jdk.net.ExtendedSocketOptions$PlatformSocketOptions") != null;
        JNIRegistrationJavaNet.initializeAtRunTime((Feature.FeatureAccess)a, "java.net.DatagramPacket", "java.net.NetworkInterface", "java.net.InetAddress", "java.net.Inet4Address", "java.net.Inet6Address", "javax.net.ssl.SSLContext");
        if (this.hasPlatformSocketOptions) {
            JNIRegistrationJavaNet.initializeAtRunTime((Feature.FeatureAccess)a, "jdk.net.ExtendedSocketOptions", "jdk.net.ExtendedSocketOptions$PlatformSocketOptions", "sun.net.ext.ExtendedSocketOptions");
        }
        if (JNIRegistrationJavaNet.isDarwin()) {
            JNIRegistrationJavaNet.initializeAtRunTime((Feature.FeatureAccess)a, "java.net.DefaultInterface");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        JNIRegistrationJavaNet.registerForThrowNew((Feature.FeatureAccess)a, "java.net.BindException", "java.net.ConnectException", "java.net.NoRouteToHostException", "java.net.PortUnreachableException", "java.net.ProtocolException", "java.net.SocketException", "java.net.SocketTimeoutException", "java.net.UnknownHostException", "sun.net.ConnectionResetException");
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetAddress", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl", "lookupAllHostAddr", String.class), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl", "lookupAllHostAddr", String.class, Integer.TYPE)});
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerNetworkInterfaceInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.NetworkInterface", "init", new Class[0])});
        if (this.hasPlatformSocketOptions) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlatformSocketOptionsCreate, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "jdk.net.ExtendedSocketOptions$PlatformSocketOptions", "create", new Class[0])});
        }
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDefaultProxySelectorInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "sun.net.spi.DefaultProxySelector", "init", new Class[0])});
    }

    static void registerInitInetAddressIDs(Feature.DuringAnalysisAccess a) {
        if (JNIRegistrationJavaNet.isRunOnce(JNIRegistrationJavaNet::registerInitInetAddressIDs)) {
            return;
        }
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress", "holder"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress$InetAddressHolder", "address", "family", "hostName", "originalHostName"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet4Address", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet6Address", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address", "holder6"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address$Inet6AddressHolder", "ipaddress", "scope_id", "scope_id_set", "scope_ifname"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "jdk.internal.util.Exceptions", "enhancedNonSocketExceptionText"));
    }

    private static void registerNetworkInterfaceInit(Feature.DuringAnalysisAccess a) {
        if (JNIRegistrationJavaNet.isRunOnce(JNIRegistrationJavaNet::registerNetworkInterfaceInit)) {
            return;
        }
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.NetworkInterface", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "name", "displayName", "index", "addrs", "bindings", "childs"));
        if (JNIRegistrationJavaNet.isPosix()) {
            RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "virtual", "parent"));
        }
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.InterfaceAddress", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InterfaceAddress", "address", "broadcast", "maskLength"));
        JNIRegistrationJavaNet.registerInitInetAddressIDs(a);
    }

    private static void registerPlatformSocketOptionsCreate(Feature.DuringAnalysisAccess a) {
        String implClassName;
        if (JNIRegistrationJavaNet.isLinux()) {
            implClassName = "jdk.net.LinuxSocketOptions";
        } else if (JNIRegistrationJavaNet.isDarwin()) {
            implClassName = "jdk.net.MacOSXSocketOptions";
        } else {
            VMError.guarantee(JNIRegistrationJavaNet.isWindows(), "Unexpected platform");
            implClassName = "jdk.net.WindowsSocketOptions";
        }
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, implClassName)});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, implClassName, new Class[0])});
    }

    private static void registerDefaultProxySelectorInit(Feature.DuringAnalysisAccess a) {
        if (JNIRegistrationJavaNet.isWindows()) {
            FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
            access.getNativeLibraries().addDynamicNonJniLibrary("winhttp");
        }
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Proxy", Proxy.Type.class, SocketAddress.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Proxy", "NO_PROXY"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Proxy$Type", "HTTP", "SOCKS"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetSocketAddress", "createUnresolved", String.class, Integer.TYPE)});
    }
}

