/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.imagelayer.FutureTrackingInfo;
import com.oracle.svm.hosted.imagelayer.PriorTrackingInfo;
import com.oracle.svm.hosted.imagelayer.TrackingInfo;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.debug.Assertions;

class ImageLayerIdTrackingSingleton
implements LayeredImageSingleton {
    private static final int UNKNOWN_HEAP_BEGIN_OFFSET = -1;
    private final Map<String, TrackingInfo> keyToTrackingInfoMap = new HashMap<String, TrackingInfo>();
    final Map<String, List<Integer>> futureKeyToPatchingOffsetsMap = new ConcurrentHashMap<String, List<Integer>>();
    private final int imageHeapBeginOffset;

    ImageLayerIdTrackingSingleton() {
        this(-1);
    }

    ImageLayerIdTrackingSingleton(int imageHeapBeginOffset) {
        this.imageHeapBeginOffset = imageHeapBeginOffset;
    }

    TrackingInfo getTrackingInfo(String key) {
        return this.keyToTrackingInfoMap.get(key);
    }

    void registerPriorTrackingInfo(String key, int constantId) {
        assert (key != null && constantId > 0) : Assertions.errorMessage((Object[])new Object[]{key, constantId});
        TrackingInfo previous = this.keyToTrackingInfoMap.putIfAbsent(key, new PriorTrackingInfo(constantId));
        VMError.guarantee(previous == null, "Two values are registered for this key %s", key);
    }

    public int getImageHeapBeginOffset() {
        return this.imageHeapBeginOffset;
    }

    public void registerFutureTrackingInfo(FutureTrackingInfo info) {
        this.updateFutureTrackingInfo0(info, false);
    }

    public void updateFutureTrackingInfo(FutureTrackingInfo info) {
        this.updateFutureTrackingInfo0(info, true);
    }

    private void updateFutureTrackingInfo0(FutureTrackingInfo info, boolean expectPrevious) {
        String key = info.key();
        assert (key != null);
        FutureTrackingInfo previous = (FutureTrackingInfo)this.keyToTrackingInfoMap.get(key);
        boolean hasPrevious = previous != null;
        VMError.guarantee(expectPrevious == hasPrevious, "Mismatch with expectPrevious: %s %s %s", expectPrevious, info, previous);
        if (previous != null) {
            boolean validState = false;
            if (info.state().ordinal() > previous.state().ordinal()) {
                validState = previous.key().equals(info.key());
            } else if (info.state() == previous.state()) {
                validState = previous.key().equals(info.key()) && info.state() != FutureTrackingInfo.State.Final && previous.loaderId() == info.loaderId();
            }
            VMError.guarantee(validState, "Invalid update %s %s", previous, info);
        }
        this.keyToTrackingInfoMap.put(key, info);
    }

    void registerPatchSite(String futureKey, int heapIndex) {
        List indexes = this.futureKeyToPatchingOffsetsMap.computeIfAbsent(futureKey, id -> new ArrayList());
        indexes.add(heapIndex);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    private static String futureKeyPatchKey(String key) {
        return String.format("futureOffsetPatches:%s", key);
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        ArrayList<String> priorKeys = new ArrayList<String>();
        ArrayList<Integer> priorIds = new ArrayList<Integer>();
        ArrayList<String> futureKeys = new ArrayList<String>();
        ArrayList<Integer> futureStates = new ArrayList<Integer>();
        ArrayList<Integer> futureLoaderIds = new ArrayList<Integer>();
        ArrayList<Integer> futureOffsets = new ArrayList<Integer>();
        for (Map.Entry<String, TrackingInfo> entry : this.keyToTrackingInfoMap.entrySet()) {
            String key = entry.getKey();
            TrackingInfo trackingInfo = entry.getValue();
            if (trackingInfo instanceof PriorTrackingInfo) {
                PriorTrackingInfo prior = (PriorTrackingInfo)trackingInfo;
                priorKeys.add(key);
                priorIds.add(prior.constantId());
                continue;
            }
            FutureTrackingInfo future = (FutureTrackingInfo)trackingInfo;
            futureKeys.add(key);
            futureStates.add(future.state().ordinal());
            futureLoaderIds.add(future.loaderId());
            if (future.state() == FutureTrackingInfo.State.Final) {
                futureOffsets.add(future.offset());
            }
            writer.writeIntList(ImageLayerIdTrackingSingleton.futureKeyPatchKey(key), this.futureKeyToPatchingOffsetsMap.getOrDefault(key, List.of()));
        }
        writer.writeStringList("priorKeys", priorKeys);
        writer.writeIntList("priorIds", priorIds);
        writer.writeStringList("futureKeys", futureKeys);
        writer.writeIntList("futureStates", futureStates);
        writer.writeIntList("futureLoaderIds", futureLoaderIds);
        writer.writeIntList("futureOffsets", futureOffsets);
        writer.writeInt("imageHeapBeginOffset", this.imageHeapBeginOffset == -1 ? Heap.getHeap().getImageHeapOffsetInAddressSpace() : this.imageHeapBeginOffset);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        ImageLayerIdTrackingSingleton tracker = new ImageLayerIdTrackingSingleton(loader.readInt("imageHeapBeginOffset"));
        Iterator<String> priorKeys = loader.readStringList("priorKeys").iterator();
        Iterator<Integer> priorIds = loader.readIntList("priorIds").iterator();
        while (priorKeys.hasNext()) {
            tracker.registerPriorTrackingInfo(priorKeys.next(), priorIds.next());
        }
        Iterator<String> futureKeys = loader.readStringList("futureKeys").iterator();
        Iterator<Integer> futureStates = loader.readIntList("futureStates").iterator();
        Iterator<Integer> futureLoaderIds = loader.readIntList("futureLoaderIds").iterator();
        Iterator<Integer> futureOffsets = loader.readIntList("futureOffsets").iterator();
        while (futureKeys.hasNext()) {
            String key = futureKeys.next();
            FutureTrackingInfo.State state = FutureTrackingInfo.State.values()[futureStates.next()];
            int loaderId = futureLoaderIds.next();
            int offset = state == FutureTrackingInfo.State.Final ? futureOffsets.next() : -1;
            tracker.registerFutureTrackingInfo(new FutureTrackingInfo(key, state, loaderId, offset));
            List<Integer> offsetsToPatch = loader.readIntList(ImageLayerIdTrackingSingleton.futureKeyPatchKey(key));
            offsetsToPatch.forEach(heapOffset -> tracker.registerPatchSite(key, (int)heapOffset));
        }
        return tracker;
    }
}

