/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.BuildingInitialLayerPredicate;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton(onlyWith={BuildingInitialLayerPredicate.class})
class DynamicHubMetadataTracking
implements LayeredImageSingleton {
    private final Set<Integer> typeIDsWithMissingHubs;

    DynamicHubMetadataTracking() {
        this.typeIDsWithMissingHubs = ConcurrentHashMap.newKeySet();
    }

    DynamicHubMetadataTracking(Set<Integer> missingHubSet) {
        this.typeIDsWithMissingHubs = missingHubSet;
    }

    static DynamicHubMetadataTracking singleton() {
        return (DynamicHubMetadataTracking)ImageSingletons.lookup(DynamicHubMetadataTracking.class);
    }

    boolean missingArrayHub(HostedType hType) {
        return this.typeIDsWithMissingHubs.contains(hType.getTypeID());
    }

    void recordMissingArrayHub(DynamicHub hub) {
        boolean added = this.typeIDsWithMissingHubs.add(hub.getTypeID());
        assert (added) : Assertions.errorMessage((Object[])new Object[]{"type recorded twice:", hub});
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        writer.writeIntList("typeIDsWithMissingArrayHubs", this.typeIDsWithMissingHubs.stream().toList());
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        Set<Integer> missingHubs = Set.copyOf(loader.readIntList("typeIDsWithMissingArrayHubs"));
        return new DynamicHubMetadataTracking(missingHubs);
    }
}

