/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.svm.core.util.ObservableImageHeapMapProvider;
import com.oracle.svm.hosted.util.ObservableMap;
import java.util.ArrayList;
import java.util.List;

public class ObservableImageHeapMapProviderImpl
implements ObservableImageHeapMapProvider {
    private List<ObservableMap<?, ?>> cachedInstances = new ArrayList();
    private ImageHeapScanner heapScanner;

    public <K, V> ObservableMap<K, V> createMap() {
        ObservableMap map = new ObservableMap();
        if (this.heapScanner == null) {
            this.cacheInstance(map);
        } else {
            this.registerWithScanner(map);
        }
        return map;
    }

    private synchronized <K, V> void cacheInstance(ObservableMap<K, V> map) {
        if (this.heapScanner == null) {
            this.cachedInstances.add(map);
        } else {
            this.registerWithScanner(map);
        }
    }

    synchronized void setHeapScanner(ImageHeapScanner scanner) {
        this.heapScanner = scanner;
        this.cachedInstances.forEach(this::registerWithScanner);
        this.cachedInstances = null;
    }

    private <K, V> void registerWithScanner(ObservableMap<K, V> map) {
        map.addObserver((key, value) -> this.heapScanner.rescanObject(value));
    }
}

