/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedSnippets;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.util.LogUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking;

@AutomaticallyRegisteredFeature
public class ClassInitializationFeature
implements InternalFeature {
    private static final String NATIVE_IMAGE_CLASS_REASON = "Native Image classes are always initialized at build time";
    private ClassInitializationSupport classInitializationSupport;

    public static void processClassInitializationOptions(ClassInitializationSupport initializationSupport) {
        ClassInitializationFeature.initializeNativeImagePackagesAtBuildTime(initializationSupport);
        ClassInitializationOptions.ClassInitialization.getValue().getValuesWithOrigins().forEach(entry -> {
            for (String optionValue : ((String)entry.value()).split(",")) {
                ClassInitializationFeature.processClassInitializationOption(initializationSupport, optionValue, entry.origin());
            }
        });
    }

    private static void processClassInitializationOption(ClassInitializationSupport initializationSupport, String optionValue, OptionOrigin origin) {
        boolean initializeAtRunTime;
        if (optionValue.endsWith(":build_time")) {
            initializeAtRunTime = false;
        } else if (optionValue.endsWith(":run_time")) {
            initializeAtRunTime = true;
        } else if (optionValue.endsWith(":rerun")) {
            LogUtils.warning((String)"Re-running class initializer is deprecated. It is equivalent with registering the class for initialization at run time. Found: %s (from %s)", (Object[])new Object[]{optionValue, origin});
            initializeAtRunTime = true;
        } else {
            throw UserError.abort("Element in class initialization configuration must end in %s, or %s. Found: %s (from %s)", ":build_time", ":run_time", optionValue, origin);
        }
        String name = optionValue.substring(0, optionValue.lastIndexOf(":"));
        String reason = "from " + String.valueOf(origin) + " with '" + name + "'";
        if (initializeAtRunTime) {
            initializationSupport.initializeAtRunTime(name, reason);
        } else {
            if (name.equals("") && !origin.commandLineLike()) {
                String msg = "--initialize-at-build-time without arguments is not allowed." + System.lineSeparator() + "Origin of the option: " + String.valueOf(origin) + System.lineSeparator() + "The reason for deprecation is that --initalize-at-build-time does not compose, i.e., a single library can make assumptions that the whole classpath can be safely initialized at build time; that assumption is often incorrect.";
                if (ClassInitializationOptions.AllowDeprecatedInitializeAllClassesAtBuildTime.getValue().booleanValue()) {
                    LogUtils.warning((String)msg);
                } else {
                    throw UserError.abort("%s%nAs a workaround, %s allows turning this error into a warning. Note that this option is deprecated and will be removed in a future version.", msg, SubstrateOptionsParser.commandArgument(ClassInitializationOptions.AllowDeprecatedInitializeAllClassesAtBuildTime, "+"));
                }
            }
            initializationSupport.initializeAtBuildTime(name, reason);
        }
    }

    private static void initializeNativeImagePackagesAtBuildTime(ClassInitializationSupport initializationSupport) {
        initializationSupport.initializeAtBuildTime("com.oracle.svm", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("com.oracle.graal", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("com.oracle.objectfile", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.collections", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("jdk.graal.compiler", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.nativeimage.libgraal", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.word", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.nativeimage", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.nativebridge", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.home", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.polyglot", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.options", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.jniutils", NATIVE_IMAGE_CLASS_REASON);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.classInitializationSupport = access.getHostVM().getClassInitializationSupport();
    }

    public void checkImageHeapInstance(Object obj) {
        if (obj != null && !this.classInitializationSupport.maybeInitializeAtBuildTime(obj.getClass())) {
            String typeName = obj.getClass().getTypeName();
            String proxyLambdaInterfaceCSV = null;
            String proxyLambdaInterfaceList = null;
            boolean proxyOrLambda = ClassInitializationSupport.isProxyOrLambda(obj);
            if (proxyOrLambda) {
                proxyLambdaInterfaceCSV = StreamSupport.stream(ClassInitializationSupport.allInterfaces(obj.getClass()).spliterator(), false).map(Class::getTypeName).collect(Collectors.joining(","));
                proxyLambdaInterfaceList = "[" + proxyLambdaInterfaceCSV.replaceAll(",", ", ") + "]";
            }
            Object msg = "An object of type '%s' was found in the image heap. This type, however, is marked for initialization at image run time for the following reason: %s.\nThis is not allowed for correctness reasons: All objects that are stored in the image heap must be initialized at build time.\n\nYou now have two options to resolve this:\n\n1) If it is intended that objects of type '%s' are persisted in the image heap, add %sto the native-image arguments. Note that initializing new types can store additional objects to the heap. It is advised to check the static fields of %s to see if they are safe for build-time initialization,  and that they do not contain any sensitive data that should not become part of the image.\n\n".replaceAll("\n", System.lineSeparator()).formatted(typeName, this.classInitializationSupport.reasonForClass(obj.getClass()), typeName, SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, proxyOrLambda ? proxyLambdaInterfaceCSV : typeName, "initialize-at-build-time", true, true), proxyOrLambda ? proxyLambdaInterfaceList : "'" + typeName + "'");
            msg = (String)msg + this.classInitializationSupport.objectInstantiationTraceMessage(obj, "2) ", culprit -> {
                if (culprit == null) {
                    return "If it is not intended that objects of type '" + typeName + "' are persisted in the image heap, examine the stack trace and use " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, "<culprit>", "initialize-at-run-time", true, true) + "to prevent instantiation of this object." + System.lineSeparator();
                }
                return "If it is not intended that objects of type '" + typeName + "' are persisted in the image heap, examine the stack trace and use " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, culprit, "initialize-at-run-time", true, true) + "to prevent instantiation of the culprit object.";
            });
            msg = (String)msg + System.lineSeparator();
            msg = (String)msg + "If you are seeing this message after upgrading to a new GraalVM release, this means that some objects ended up in the image heap without their type being marked with --initialize-at-build-time.\nTo fix this, include %s in your configuration. If the classes do not originate from your code, it is advised to update all library or framework dependencies to the latest version before addressing this error.\n".replaceAll("\n", System.lineSeparator()).formatted(SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, proxyOrLambda ? proxyLambdaInterfaceCSV : typeName, "initialize-at-build-time", true, false));
            msg = (String)msg + System.lineSeparator() + "The following detailed trace displays from which field in the code the object was reached.";
            throw new UnsupportedFeatureException((String)msg);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : EnsureClassInitializedSnippets.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true, (Object)("Class initialization foreign call, registered in " + String.valueOf(ClassInitializationFeature.class)), new MultiMethod.MultiMethodKey[0]);
        }
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(EnsureClassInitializedSnippets.FOREIGN_CALLS);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        EnsureClassInitializedSnippets.registerLowerings(options, providers, lowerings);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess a) {
        FeatureImpl.AfterAnalysisAccessImpl access = (FeatureImpl.AfterAnalysisAccessImpl)a;
        try (Timer.StopTimer ignored = TimerCollection.createTimerAndStart((TimerCollection.Registry)TimerCollection.Registry.CLINIT);){
            List unspecifiedClasses;
            if (ClassInitializationOptions.PrintClassInitialization.getValue().booleanValue()) {
                this.reportClassInitializationInfo(access, SubstrateOptions.reportsPath());
            }
            if (SubstrateOptions.TraceClassInitialization.hasBeenSet()) {
                ClassInitializationFeature.reportTrackedClassInitializationTraces(SubstrateOptions.reportsPath());
            }
            if (ClassInitializationOptions.AssertInitializationSpecifiedForAllClasses.getValue().booleanValue() && !(unspecifiedClasses = this.classInitializationSupport.classesWithKind(InitKind.RUN_TIME).stream().filter(c -> c.getClassLoader() != null && c.getClassLoader() != ClassLoader.getPlatformClassLoader()).filter(c -> this.classInitializationSupport.specifiedInitKindFor((Class<?>)c) == null).map(Class::getTypeName).filter(name -> !name.contains("$$Lambda")).collect(Collectors.toList())).isEmpty()) {
                System.err.println("The following classes have unspecified initialization policy:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), unspecifiedClasses));
                UserError.abort("To fix the error either specify the initialization policy for given classes or set %s", SubstrateOptionsParser.commandArgument(ClassInitializationOptions.AssertInitializationSpecifiedForAllClasses, "-"));
            }
        }
    }

    private void reportClassInitializationInfo(FeatureImpl.AfterAnalysisAccessImpl access, String path) {
        ReportUtils.report((String)"class initialization report", (String)path, (String)"class_initialization_report", (String)"csv", writer -> {
            writer.println("Class Name, Initialization Kind, Reason for Initialization");
            this.reportKind(access, (PrintWriter)writer, InitKind.BUILD_TIME);
            this.reportKind(access, (PrintWriter)writer, InitKind.RUN_TIME);
        });
    }

    private void reportKind(FeatureImpl.AfterAnalysisAccessImpl access, PrintWriter writer, InitKind kind) {
        ArrayList allClasses = new ArrayList(this.classInitializationSupport.classesWithKind(kind));
        allClasses.sort(Comparator.comparing(Class::getTypeName));
        allClasses.forEach(clazz -> {
            Optional type;
            writer.print(clazz.getTypeName() + ", ");
            boolean simulated = false;
            if (kind != InitKind.BUILD_TIME && (type = access.getMetaAccess().optionalLookupJavaType(clazz)).isPresent()) {
                simulated = SimulateClassInitializerSupport.singleton().isClassInitializerSimulated((AnalysisType)type.get());
            }
            if (simulated) {
                writer.print("SIMULATED, ");
            } else {
                writer.print(String.valueOf((Object)kind) + ", ");
            }
            writer.println(this.classInitializationSupport.reasonForClass((Class<?>)clazz));
        });
    }

    private static void reportTrackedClassInitializationTraces(String path) {
        Map initializedClasses = ClassInitializationTracking.initializedClasses;
        int size = initializedClasses.size();
        if (size > 0) {
            ReportUtils.report((String)(size + " class initialization trace(s) of class(es) traced by " + SubstrateOptions.TraceClassInitialization.getName()), (String)path, (String)"traced_class_initialization", (String)"txt", writer -> initializedClasses.forEach((k, v) -> {
                writer.println(k.getName());
                writer.println("---------------------------------------------");
                writer.println(ClassInitializationSupport.getTraceString(v));
                writer.println();
            }));
        }
    }
}

