/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.query;

import com.oracle.svm.core.c.enums.CEnumArrayLookup;
import com.oracle.svm.core.c.enums.CEnumMapLookup;
import com.oracle.svm.core.c.enums.CEnumNoLookup;
import com.oracle.svm.core.c.enums.CEnumRuntimeData;
import com.oracle.svm.core.c.struct.CInterfaceLocationIdentity;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.query.NativeInfoTreeVisitor;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.AnnotatedElement;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumConstant;
import org.graalvm.nativeimage.c.struct.AllowNarrowingCast;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;

public final class SizeAndSignednessVerifier
extends NativeInfoTreeVisitor {
    private SizeAndSignednessVerifier(NativeLibraries nativeLibs) {
        super(nativeLibs);
    }

    public static void verify(NativeLibraries nativeLibs, NativeCodeInfo nativeCodeInfo) {
        SizeAndSignednessVerifier verifier = new SizeAndSignednessVerifier(nativeLibs);
        nativeCodeInfo.accept(verifier);
    }

    @Override
    protected void visitConstantInfo(ConstantInfo constantInfo) {
        if (constantInfo.getKind() != SizableInfo.ElementKind.STRING && constantInfo.getKind() != SizableInfo.ElementKind.BYTEARRAY) {
            ResolvedJavaMethod method = constantInfo.getAnnotatedElement();
            ResolvedJavaType returnType = AccessorInfo.getReturnType(method);
            this.verifySize(constantInfo, returnType, method, true);
        }
    }

    @Override
    protected void visitStructFieldInfo(StructFieldInfo structFieldInfo) {
        this.checkAccessorLocationIdentity(structFieldInfo.getChildren());
        if (structFieldInfo.getAnyAccessorInfo().hasUniqueLocationIdentity()) {
            structFieldInfo.setLocationIdentity(new CInterfaceLocationIdentity(structFieldInfo.getParent().getName() + "." + structFieldInfo.getName()));
        }
        super.visitStructFieldInfo(structFieldInfo);
    }

    @Override
    protected void visitStructBitfieldInfo(StructBitfieldInfo structBitfieldInfo) {
        this.checkAccessorLocationIdentity(structBitfieldInfo.getChildren());
        super.visitStructBitfieldInfo(structBitfieldInfo);
    }

    private void checkAccessorLocationIdentity(List<ElementInfo> children) {
        AccessorInfo firstAccessorInfo = null;
        for (ElementInfo child : children) {
            AccessorInfo accessorInfo;
            if (!(child instanceof AccessorInfo) || (accessorInfo = (AccessorInfo)child).getAccessorKind() == AccessorInfo.AccessorKind.OFFSET) continue;
            if (firstAccessorInfo == null) {
                firstAccessorInfo = accessorInfo;
                continue;
            }
            if (accessorInfo.hasLocationIdentityParameter() != firstAccessorInfo.hasLocationIdentityParameter()) {
                this.addError("All accessors for a field must agree on LocationIdentity parameter", firstAccessorInfo, accessorInfo);
                continue;
            }
            if (accessorInfo.hasUniqueLocationIdentity() == firstAccessorInfo.hasUniqueLocationIdentity()) continue;
            this.addError("All accessors for a field must agree on @" + UniqueLocationIdentity.class.getSimpleName() + " annotation", firstAccessorInfo, accessorInfo);
        }
    }

    @Override
    protected void visitAccessorInfo(AccessorInfo accessorInfo) {
        ResolvedJavaMethod method = accessorInfo.getAnnotatedElement();
        ResolvedJavaType returnType = accessorInfo.getReturnType();
        if (accessorInfo.getParent() instanceof StructBitfieldInfo) {
            assert (accessorInfo.getAccessorKind() == AccessorInfo.AccessorKind.GETTER || accessorInfo.getAccessorKind() == AccessorInfo.AccessorKind.SETTER);
        } else {
            SizableInfo sizableInfo = (SizableInfo)accessorInfo.getParent();
            switch (accessorInfo.getAccessorKind()) {
                case ADDRESS: {
                    assert (this.nativeLibs.isPointerBase(returnType));
                    break;
                }
                case OFFSET: {
                    assert (this.nativeLibs.isIntegerType(returnType));
                    break;
                }
                case GETTER: {
                    this.verifySize(sizableInfo, returnType, method, true);
                    this.verifySignedness(sizableInfo, returnType, method);
                    break;
                }
                case SETTER: {
                    assert (returnType.getJavaKind() == JavaKind.Void);
                    ResolvedJavaType valueType = accessorInfo.getValueParameterType();
                    this.verifySize(sizableInfo, valueType, method, false);
                    this.verifySignedness(sizableInfo, valueType, method);
                }
            }
        }
    }

    @Override
    protected void visitEnumInfo(EnumInfo enumInfo) {
        this.verifyCEnumValueMethodReturnTypes(enumInfo);
        this.verifyCEnumLookupMethodArguments(enumInfo);
        CEnumRuntimeData runtimeData = this.createCEnumRuntimeData(enumInfo);
        enumInfo.setRuntimeData(runtimeData);
        super.visitEnumInfo(enumInfo);
    }

    private CEnumRuntimeData createCEnumRuntimeData(EnumInfo enumInfo) {
        long spread;
        HashMap javaToC = new HashMap();
        HashMap cToJava = new HashMap();
        long minLookupValue = Long.MAX_VALUE;
        long maxLookupValue = Long.MIN_VALUE;
        for (ElementInfo elementInfo : enumInfo.getChildren()) {
            if (!(elementInfo instanceof EnumConstantInfo)) continue;
            EnumConstantInfo enumConstantInfo = (EnumConstantInfo)elementInfo;
            long cValue = this.limitValueToEnumBytes(enumInfo, enumConstantInfo);
            Enum<?> javaValue = enumConstantInfo.getEnumValue();
            assert (!javaToC.containsKey(javaValue));
            javaToC.put(javaValue, cValue);
            if (!enumInfo.hasCEnumLookupMethods() || !enumConstantInfo.getIncludeInLookup()) continue;
            if (cToJava.containsKey(cValue)) {
                this.addError("C value is not unique, so reverse lookup from C to Java is not possible: " + String.valueOf(cToJava.get(cValue)) + " and " + String.valueOf(javaValue) + " have the same C value " + cValue + ". Please exclude one of the values from the lookup (see @" + CEnumConstant.class.getSimpleName() + " for more details).", enumConstantInfo.getAnnotatedElement());
            }
            cToJava.put(cValue, javaValue);
            minLookupValue = Math.min(minLookupValue, cValue);
            maxLookupValue = Math.max(maxLookupValue, cValue);
        }
        long[] javaToCArray = new long[javaToC.size()];
        for (Map.Entry entry : javaToC.entrySet()) {
            int idx = ((Enum)entry.getKey()).ordinal();
            assert (idx >= 0 && idx < javaToCArray.length && javaToCArray[idx] == 0L) : "ordinal values are defined as unique and consecutive";
            javaToCArray[idx] = (Long)entry.getValue();
        }
        int n = enumInfo.getSizeInBytes();
        boolean bl = enumInfo.isUnsigned();
        if (cToJava.isEmpty()) {
            return new CEnumNoLookup(javaToCArray, n, bl);
        }
        assert (minLookupValue <= maxLookupValue);
        BigInteger bigIntSpread = BigInteger.valueOf(maxLookupValue).subtract(BigInteger.valueOf(minLookupValue));
        assert (bigIntSpread.compareTo(BigInteger.valueOf(cToJava.size() - 1)) >= 0);
        long l = spread = bigIntSpread.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? Long.MAX_VALUE : bigIntSpread.longValue();
        if (spread < (long)cToJava.size() * 5L && spread < 0x7FFFFFF5L) {
            int arraySize = NumUtil.safeToInt((long)(spread + 1L));
            Enum[] cToJavaArray = new Enum[arraySize];
            for (Map.Entry entry : cToJava.entrySet()) {
                int idx = NumUtil.safeToInt((long)((Long)entry.getKey() - minLookupValue));
                assert (idx >= 0 && idx < cToJavaArray.length);
                assert (cToJavaArray[idx] == null);
                cToJavaArray[idx] = (Enum)entry.getValue();
            }
            return new CEnumArrayLookup(javaToCArray, n, bl, minLookupValue, cToJavaArray);
        }
        return new CEnumMapLookup(javaToCArray, n, bl, Map.copyOf(cToJava));
    }

    private void verifyCEnumValueMethodReturnTypes(EnumInfo enumInfo) {
        for (ResolvedJavaMethod resolvedJavaMethod : enumInfo.getCEnumValueMethods()) {
            ResolvedJavaType returnType = AccessorInfo.getReturnType(resolvedJavaMethod);
            this.verifySize(enumInfo, returnType, resolvedJavaMethod, true);
        }
    }

    private void verifyCEnumLookupMethodArguments(EnumInfo enumInfo) {
        for (ResolvedJavaMethod resolvedJavaMethod : enumInfo.getCEnumLookupMethods()) {
            ResolvedJavaType arg0 = AccessorInfo.getParameterType(resolvedJavaMethod, 0);
            this.verifySize(enumInfo, arg0, resolvedJavaMethod, false);
        }
    }

    private void verifySize(SizableInfo sizableInfo, ResolvedJavaType type, ResolvedJavaMethod method, boolean isReturn) {
        int actualSize;
        boolean allowWideningCast;
        int declaredSize = this.getSizeInBytes(type);
        boolean allowNarrowingCast = AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, AllowNarrowingCast.class);
        if (allowNarrowingCast) {
            if (sizableInfo.isObject()) {
                this.addError(ClassUtil.getUnqualifiedName(AllowNarrowingCast.class) + " cannot be used on fields that have an object type.", method);
            } else if (sizableInfo.getKind() == SizableInfo.ElementKind.FLOAT) {
                this.addError(ClassUtil.getUnqualifiedName(AllowNarrowingCast.class) + " cannot be used on fields of type float or double.", method);
            }
        }
        if (allowWideningCast = AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, AllowWideningCast.class)) {
            if (sizableInfo.isObject()) {
                this.addError(ClassUtil.getUnqualifiedName(AllowWideningCast.class) + " cannot be used on fields that have an object type.", method);
            } else if (sizableInfo.getKind() == SizableInfo.ElementKind.FLOAT) {
                this.addError(ClassUtil.getUnqualifiedName(AllowWideningCast.class) + " cannot be used on fields of type float or double.", method);
            }
        }
        int n = actualSize = sizableInfo.isObject() ? this.getSizeInBytes(JavaKind.Object) : sizableInfo.getSizeInBytes();
        if (declaredSize != actualSize) {
            Class suppressionAnnotation;
            boolean narrow;
            boolean bl = narrow = declaredSize > actualSize;
            if (isReturn) {
                narrow = !narrow;
            }
            Class clazz = suppressionAnnotation = narrow ? AllowNarrowingCast.class : AllowWideningCast.class;
            if (method.getAnnotation(suppressionAnnotation) == null) {
                this.addError("Type " + type.toJavaName(false) + " has a size of " + declaredSize + " bytes, but accessed C value has a size of " + actualSize + " bytes; to suppress this error, use the annotation @" + ClassUtil.getUnqualifiedName(suppressionAnnotation), method);
            }
        }
    }

    private void verifySignedness(SizableInfo sizableInfo, ResolvedJavaType type, ResolvedJavaMethod method) {
        if (Options.VerifyCInterfaceSignedness.getValue().booleanValue() && sizableInfo.getKind() == SizableInfo.ElementKind.INTEGER) {
            boolean isCTypeSigned;
            boolean isJavaTypeSigned = this.nativeLibs.isSigned(type);
            boolean bl = isCTypeSigned = sizableInfo.getSignednessInfo().getProperty() == SizableInfo.SignednessValue.SIGNED;
            if (isJavaTypeSigned != isCTypeSigned) {
                this.addError("Java type " + type.toJavaName(false) + " is " + (isJavaTypeSigned ? "signed" : "unsigned") + ", while the accessed C value is " + (isCTypeSigned ? "signed" : "unsigned"), method);
            }
        }
    }

    private long limitValueToEnumBytes(EnumInfo enumInfo, EnumConstantInfo constantInfo) {
        int enumBits = enumInfo.getSizeInBytes() * 8;
        long result = constantInfo.getValue();
        result = constantInfo.isUnsigned() ? CodeUtil.zeroExtend((long)result, (int)enumBits) : CodeUtil.signExtend((long)result, (int)enumBits);
        if (result != constantInfo.getValue()) {
            this.addError("The value of a C constant does not fit into the C data type of the @" + CEnum.class.getSimpleName() + " ('" + enumInfo.getName() + "'). Please specify a larger C data type in @" + CEnum.class.getSimpleName() + "(value = \"...\").", enumInfo, constantInfo);
        }
        return result;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> VerifyCInterfaceSignedness = new HostedOptionKey<Boolean>(false);
    }
}

