/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.PropertyInfo;

public abstract class SizableInfo
extends ElementInfo {
    private final ElementKind kind;
    private final PropertyInfo<Integer> sizeInfo;
    private final PropertyInfo<SignednessValue> signednessInfo;

    public SizableInfo(String name, ElementKind kind) {
        super(name);
        this.kind = kind;
        this.sizeInfo = this.adoptChild(new PropertyInfo("size"));
        this.signednessInfo = kind == ElementKind.INTEGER ? this.adoptChild(new PropertyInfo("signedness")) : null;
    }

    public final ElementKind getKind() {
        return this.kind;
    }

    public final int getSizeInBytes() {
        return this.getSizeInfo().getProperty();
    }

    public final PropertyInfo<Integer> getSizeInfo() {
        return this.sizeInfo;
    }

    public final PropertyInfo<SignednessValue> getSignednessInfo() {
        assert (this.signednessInfo != null);
        return this.signednessInfo;
    }

    public final boolean isUnsigned() {
        return this.getKind() == ElementKind.POINTER || this.getKind() == ElementKind.INTEGER && this.getSignednessInfo().getProperty() == SignednessValue.UNSIGNED;
    }

    public final boolean isObject() {
        return this.getKind() == ElementKind.OBJECT;
    }

    public static enum ElementKind {
        INTEGER,
        POINTER,
        FLOAT,
        STRING,
        BYTEARRAY,
        OBJECT,
        UNKNOWN;

    }

    public static enum SignednessValue {
        SIGNED,
        UNSIGNED;

    }
}

