/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.meta.BaseLayerElement;
import com.oracle.graal.pointsto.meta.BaseLayerField;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.reflect.ConstantPool;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.impl.AnnotationExtractor;

public class SubstrateAnnotationExtractor
implements AnnotationExtractor,
LayeredImageSingleton {
    private final Map<Class<?>, AnnotationValue[]> annotationCache = new ConcurrentHashMap();
    private final Map<AnnotatedElement, AnnotationValue[]> declaredAnnotationCache = new ConcurrentHashMap<AnnotatedElement, AnnotationValue[]>();
    private final Map<Executable, AnnotationValue[][]> parameterAnnotationCache = new ConcurrentHashMap<Executable, AnnotationValue[][]>();
    private final Map<AnnotatedElement, TypeAnnotationValue[]> typeAnnotationCache = new ConcurrentHashMap<AnnotatedElement, TypeAnnotationValue[]>();
    private final Map<Method, AnnotationMemberValue> annotationDefaultCache = new ConcurrentHashMap<Method, AnnotationMemberValue>();
    private final Map<AnnotationValue, Annotation> resolvedAnnotationsCache = new ConcurrentHashMap<AnnotationValue, Annotation>();
    private static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
    private static final AnnotationValue[][] NO_PARAMETER_ANNOTATIONS = new AnnotationValue[0][0];
    private static final TypeAnnotationValue[] NO_TYPE_ANNOTATIONS = new TypeAnnotationValue[0];
    private static final Method classGetRawAnnotations = ReflectionUtil.lookupMethod(Class.class, (String)"getRawAnnotations", (Class[])new Class[0]);
    private static final Method classGetRawTypeAnnotations = ReflectionUtil.lookupMethod(Class.class, (String)"getRawTypeAnnotations", (Class[])new Class[0]);
    private static final Method classGetConstantPool = ReflectionUtil.lookupMethod(Class.class, (String)"getConstantPool", (Class[])new Class[0]);
    private static final Field fieldAnnotations = ReflectionUtil.lookupField(Field.class, (String)"annotations");
    private static final Method fieldGetTypeAnnotationBytes = ReflectionUtil.lookupMethod(Field.class, (String)"getTypeAnnotationBytes0", (Class[])new Class[0]);
    private static final Method executableGetAnnotationBytes = ReflectionUtil.lookupMethod(Executable.class, (String)"getAnnotationBytes", (Class[])new Class[0]);
    private static final Method executableGetTypeAnnotationBytes = ReflectionUtil.lookupMethod(Executable.class, (String)"getTypeAnnotationBytes", (Class[])new Class[0]);
    private static final Field methodParameterAnnotations = ReflectionUtil.lookupField(Method.class, (String)"parameterAnnotations");
    private static final Field methodAnnotationDefault = ReflectionUtil.lookupField(Method.class, (String)"annotationDefault");
    private static final Field constructorParameterAnnotations = ReflectionUtil.lookupField(Constructor.class, (String)"parameterAnnotations");
    private static final Class<?> recordComponentClass = ReflectionUtil.lookupClass((boolean)true, (String)"java.lang.reflect.RecordComponent");
    private static final Field recordComponentAnnotations = recordComponentClass == null ? null : ReflectionUtil.lookupField(recordComponentClass, (String)"annotations");
    private static final Field recordComponentTypeAnnotations = recordComponentClass == null ? null : ReflectionUtil.lookupField(recordComponentClass, (String)"typeAnnotations");
    private static final Method recordComponentGetDeclaringRecord = recordComponentClass == null ? null : ReflectionUtil.lookupMethod(recordComponentClass, (String)"getDeclaringRecord", (Class[])new Class[0]);
    private static final Method packageGetPackageInfo = ReflectionUtil.lookupMethod(Package.class, (String)"getPackageInfo", (Class[])new Class[0]);

    public static AnnotationValue[] prepareInjectedAnnotations(Annotation ... annotations) {
        if (annotations == null || annotations.length == 0) {
            return NO_ANNOTATIONS;
        }
        AnnotationValue[] result = new AnnotationValue[annotations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new AnnotationValue(Objects.requireNonNull(annotations[i]));
        }
        return result;
    }

    public <T extends Annotation> T extractAnnotation(AnnotatedElement element, Class<T> annotationType, boolean declaredOnly) {
        try {
            for (AnnotationValue annotation : this.getAnnotationData(element, declaredOnly)) {
                if (annotation.type == null || !annotation.type.equals(annotationType)) continue;
                return (T)this.resolvedAnnotationsCache.computeIfAbsent(annotation, value -> (Annotation)value.get(annotationType));
            }
            return null;
        }
        catch (LinkageError e) {
            return null;
        }
    }

    public boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        try {
            for (AnnotationValue annotation : this.getAnnotationData(element, false)) {
                if (annotation.type == null || !annotation.type.equals(annotationType)) continue;
                return true;
            }
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    public Class<? extends Annotation>[] getAnnotationTypes(AnnotatedElement element) {
        return (Class[])Arrays.stream(this.getAnnotationData(element, false)).map(AnnotationValue::getType).filter(Objects::nonNull).toArray(Class[]::new);
    }

    public AnnotationValue[] getDeclaredAnnotationData(AnnotatedElement element) {
        return this.getAnnotationData(element, true);
    }

    private AnnotationValue[] getAnnotationData(AnnotatedElement element, boolean declaredOnly) {
        AnnotatedElement cur = element;
        while (cur instanceof WrappedElement) {
            cur = ((WrappedElement)cur).getWrapped();
        }
        AnnotationValue[] result = NO_ANNOTATIONS;
        while (cur instanceof AnnotationWrapper) {
            AnnotationWrapper wrapper = (AnnotationWrapper)cur;
            result = SubstrateAnnotationExtractor.concat(result, wrapper.getInjectedAnnotations());
            cur = wrapper.getAnnotationRoot();
        }
        AnnotatedElement root = SubstrateAnnotationExtractor.findRoot(cur);
        if (root instanceof BaseLayerElement) {
            BaseLayerElement baseLayerElement = (BaseLayerElement)root;
            result = Arrays.stream(baseLayerElement.getBaseLayerAnnotations()).map(AnnotationValue::new).toList().toArray(new AnnotationValue[0]);
        } else if (root != null) {
            result = SubstrateAnnotationExtractor.concat(result, declaredOnly ? this.getDeclaredAnnotationDataFromRoot(root) : this.getAnnotationDataFromRoot(root));
        }
        return result;
    }

    private static AnnotationValue[] concat(AnnotationValue[] a1, AnnotationValue[] a2) {
        if (a2 == null || a2.length == 0) {
            return a1;
        }
        if (a1 == null || a1.length == 0) {
            return a2;
        }
        AnnotationValue[] result = (AnnotationValue[])Arrays.copyOf(a1, a1.length + a2.length, AnnotationValue[].class);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    private AnnotationValue[] getAnnotationDataFromRoot(AnnotatedElement rootElement) {
        if (!(rootElement instanceof Class)) {
            return this.getDeclaredAnnotationDataFromRoot(rootElement);
        }
        Class clazz = (Class)rootElement;
        AnnotationValue[] existing = this.annotationCache.get(clazz);
        if (existing != null) {
            return existing;
        }
        ArrayList<AnnotationValue> inheritedAnnotations = new ArrayList<AnnotationValue>();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            for (AnnotationValue superclassAnnotation : this.getAnnotationDataFromRoot(superClass)) {
                if (!this.hasAnnotation(superclassAnnotation.type, Inherited.class)) continue;
                inheritedAnnotations.add(superclassAnnotation);
            }
        }
        return this.annotationCache.computeIfAbsent(clazz, element -> {
            AnnotationValue[] declaredAnnotations = this.getDeclaredAnnotationDataFromRoot((AnnotatedElement)element);
            LinkedHashMap<Class<? extends Annotation>, AnnotationValue> annotations = new LinkedHashMap<Class<? extends Annotation>, AnnotationValue>();
            for (AnnotationValue declaredAnnotation : declaredAnnotations) {
                annotations.put(declaredAnnotation.type, declaredAnnotation);
            }
            boolean modified = false;
            for (AnnotationValue inheritedAnnotation : inheritedAnnotations) {
                if (annotations.containsKey(inheritedAnnotation.type)) continue;
                annotations.put(inheritedAnnotation.type, inheritedAnnotation);
                modified = true;
            }
            return modified ? annotations.values().toArray(NO_ANNOTATIONS) : declaredAnnotations;
        });
    }

    private AnnotationValue[] getDeclaredAnnotationDataFromRoot(AnnotatedElement rootElement) {
        return this.declaredAnnotationCache.computeIfAbsent(rootElement, element -> {
            byte[] rawAnnotations = SubstrateAnnotationExtractor.getRawAnnotations(element);
            if (rawAnnotations == null) {
                return NO_ANNOTATIONS;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawAnnotations);
            try {
                ArrayList<AnnotationValue> annotations = new ArrayList<AnnotationValue>();
                int numAnnotations = buf.getShort() & 0xFFFF;
                for (int i = 0; i < numAnnotations; ++i) {
                    AnnotationValue annotation = AnnotationValue.extract(buf, SubstrateAnnotationExtractor.getConstantPool(element), SubstrateAnnotationExtractor.getContainer(element), false, false);
                    if (annotation == null) continue;
                    annotations.add(annotation);
                }
                return annotations.toArray(NO_ANNOTATIONS);
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return new AnnotationValue[]{AnnotationValue.forAnnotationFormatException()};
            }
        });
    }

    public AnnotationValue[][] getParameterAnnotationData(AnnotatedElement element) {
        AnnotatedElement root = SubstrateAnnotationExtractor.findRoot(SubstrateAnnotationExtractor.unwrap(element));
        return root != null ? this.getParameterAnnotationDataFromRoot((Executable)root) : NO_PARAMETER_ANNOTATIONS;
    }

    private AnnotationValue[][] getParameterAnnotationDataFromRoot(Executable rootElement) {
        return this.parameterAnnotationCache.computeIfAbsent(rootElement, element -> {
            byte[] rawParameterAnnotations = SubstrateAnnotationExtractor.getRawParameterAnnotations(element);
            if (rawParameterAnnotations == null) {
                return NO_PARAMETER_ANNOTATIONS;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawParameterAnnotations);
            try {
                int numParameters = buf.get() & 0xFF;
                if (numParameters == 0) {
                    return NO_PARAMETER_ANNOTATIONS;
                }
                AnnotationValue[][] parameterAnnotations = new AnnotationValue[numParameters][];
                for (int i = 0; i < numParameters; ++i) {
                    ArrayList<AnnotationValue> parameterAnnotationList = new ArrayList<AnnotationValue>();
                    int numAnnotations = buf.getShort() & 0xFFFF;
                    for (int j = 0; j < numAnnotations; ++j) {
                        AnnotationValue parameterAnnotation = AnnotationValue.extract(buf, SubstrateAnnotationExtractor.getConstantPool(element), SubstrateAnnotationExtractor.getContainer(element), false, false);
                        if (parameterAnnotation == null) continue;
                        parameterAnnotationList.add(parameterAnnotation);
                    }
                    parameterAnnotations[i] = parameterAnnotationList.toArray(NO_ANNOTATIONS);
                }
                return parameterAnnotations;
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return new AnnotationValue[][]{{AnnotationValue.forAnnotationFormatException()}};
            }
        });
    }

    public TypeAnnotationValue[] getTypeAnnotationData(AnnotatedElement element) {
        AnnotatedElement root = SubstrateAnnotationExtractor.findRoot(SubstrateAnnotationExtractor.unwrap(element));
        return root != null ? this.getTypeAnnotationDataFromRoot(root) : NO_TYPE_ANNOTATIONS;
    }

    private TypeAnnotationValue[] getTypeAnnotationDataFromRoot(AnnotatedElement rootElement) {
        return this.typeAnnotationCache.computeIfAbsent(rootElement, element -> {
            byte[] rawTypeAnnotations = SubstrateAnnotationExtractor.getRawTypeAnnotations(element);
            if (rawTypeAnnotations == null) {
                return NO_TYPE_ANNOTATIONS;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawTypeAnnotations);
            try {
                int annotationCount = buf.getShort() & 0xFFFF;
                TypeAnnotationValue[] typeAnnotationValues = new TypeAnnotationValue[annotationCount];
                for (int i = 0; i < annotationCount; ++i) {
                    typeAnnotationValues[i] = TypeAnnotationValue.extract(buf, SubstrateAnnotationExtractor.getConstantPool(element), SubstrateAnnotationExtractor.getContainer(element));
                }
                return typeAnnotationValues;
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return new TypeAnnotationValue[]{new TypeAnnotationValue(new byte[]{119}, new byte[]{0}, AnnotationValue.forAnnotationFormatException())};
            }
        });
    }

    public AnnotationMemberValue getAnnotationDefaultData(AnnotatedElement element) {
        AnnotatedElement root = SubstrateAnnotationExtractor.findRoot(SubstrateAnnotationExtractor.unwrap(element));
        return root != null ? this.getAnnotationDefaultDataFromRoot((Method)root) : null;
    }

    private AnnotationMemberValue getAnnotationDefaultDataFromRoot(Method accessorMethod) {
        return this.annotationDefaultCache.computeIfAbsent(accessorMethod, method -> {
            byte[] rawAnnotationDefault = SubstrateAnnotationExtractor.getRawAnnotationDefault(method);
            if (rawAnnotationDefault == null) {
                return null;
            }
            ByteBuffer buf = ByteBuffer.wrap(rawAnnotationDefault);
            try {
                return AnnotationMemberValue.extract(buf, SubstrateAnnotationExtractor.getConstantPool(method), SubstrateAnnotationExtractor.getContainer(method), false);
            }
            catch (IllegalArgumentException | BufferUnderflowException ex) {
                return AnnotationValue.forAnnotationFormatException();
            }
        });
    }

    private static byte[] getRawAnnotations(AnnotatedElement rootElement) {
        try {
            if (rootElement instanceof Class) {
                return (byte[])classGetRawAnnotations.invoke((Object)rootElement, new Object[0]);
            }
            if (rootElement instanceof Field) {
                return (byte[])fieldAnnotations.get(rootElement);
            }
            if (rootElement instanceof Executable) {
                return (byte[])executableGetAnnotationBytes.invoke((Object)rootElement, new Object[0]);
            }
            if (recordComponentClass != null && recordComponentClass.isInstance(rootElement)) {
                return (byte[])recordComponentAnnotations.get(rootElement);
            }
            throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, "Unexpected annotated element type: " + String.valueOf(rootElement.getClass()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, (Throwable)e);
        }
    }

    private static byte[] getRawParameterAnnotations(Executable rootElement) {
        try {
            if (rootElement instanceof Method) {
                return (byte[])methodParameterAnnotations.get(rootElement);
            }
            if (rootElement instanceof Constructor) {
                return (byte[])constructorParameterAnnotations.get(rootElement);
            }
            throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, "Unexpected annotated element type: " + String.valueOf(rootElement.getClass()));
        }
        catch (IllegalAccessException e) {
            throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, (Throwable)e);
        }
    }

    private static byte[] getRawTypeAnnotations(AnnotatedElement rootElement) {
        try {
            if (rootElement instanceof Class) {
                return (byte[])classGetRawTypeAnnotations.invoke((Object)rootElement, new Object[0]);
            }
            if (rootElement instanceof Field) {
                return (byte[])fieldGetTypeAnnotationBytes.invoke((Object)rootElement, new Object[0]);
            }
            if (rootElement instanceof Executable) {
                return (byte[])executableGetTypeAnnotationBytes.invoke((Object)rootElement, new Object[0]);
            }
            if (recordComponentClass != null && recordComponentClass.isInstance(rootElement)) {
                return (byte[])recordComponentTypeAnnotations.get(rootElement);
            }
            throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, "Unexpected annotated element type: " + String.valueOf(rootElement.getClass()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, (Throwable)e);
        }
    }

    private static byte[] getRawAnnotationDefault(Method method) {
        try {
            return (byte[])methodAnnotationDefault.get(method);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationMetadata.AnnotationExtractionError((Object)method, (Throwable)e);
        }
    }

    private static ConstantPool getConstantPool(AnnotatedElement rootElement) {
        Class<?> container = SubstrateAnnotationExtractor.getContainer(rootElement);
        try {
            return (ConstantPool)classGetConstantPool.invoke(container, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, (Throwable)e);
        }
    }

    private static Class<?> getContainer(AnnotatedElement rootElement) {
        if (rootElement instanceof Class) {
            return (Class)rootElement;
        }
        if (rootElement instanceof Field) {
            return ((Field)rootElement).getDeclaringClass();
        }
        if (rootElement instanceof Executable) {
            return ((Executable)rootElement).getDeclaringClass();
        }
        if (recordComponentClass != null && recordComponentClass.isInstance(rootElement)) {
            try {
                return (Class)recordComponentGetDeclaringRecord.invoke((Object)rootElement, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, (Throwable)e);
            }
        }
        throw new AnnotationMetadata.AnnotationExtractionError((Object)rootElement, "Unexpected annotated element type: " + String.valueOf(rootElement.getClass()));
    }

    private static AnnotatedElement unwrap(AnnotatedElement element) {
        AnnotatedElement cur = element;
        while (cur instanceof WrappedElement) {
            cur = ((WrappedElement)cur).getWrapped();
        }
        while (cur instanceof AnnotationWrapper) {
            cur = ((AnnotationWrapper)cur).getAnnotationRoot();
        }
        return cur;
    }

    private static AnnotatedElement findRoot(AnnotatedElement element) {
        assert (!(element instanceof WrappedElement) && !(element instanceof AnnotationWrapper));
        try {
            if (element instanceof BaseLayerType || element instanceof BaseLayerMethod || element instanceof BaseLayerField) {
                return element;
            }
            if (element instanceof ResolvedJavaType) {
                ResolvedJavaType type = (ResolvedJavaType)element;
                return OriginalClassProvider.getJavaClass((JavaType)type);
            }
            if (element instanceof ResolvedJavaMethod) {
                ResolvedJavaMethod method = (ResolvedJavaMethod)element;
                return OriginalMethodProvider.getJavaMethod((ResolvedJavaMethod)method);
            }
            if (element instanceof ResolvedJavaField) {
                ResolvedJavaField field = (ResolvedJavaField)element;
                return OriginalFieldProvider.getJavaField((ResolvedJavaField)field);
            }
            if (element instanceof Package) {
                Package packageObject = (Package)element;
                return (Class)packageGetPackageInfo.invoke((Object)packageObject, new Object[0]);
            }
            return element;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof LinkageError) {
                throw (LinkageError)targetException;
            }
            throw new AnnotationMetadata.AnnotationExtractionError((Object)element, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AnnotationMetadata.AnnotationExtractionError((Object)element, (Throwable)e);
        }
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        return LayeredImageSingleton.PersistFlags.NOTHING;
    }
}

