/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.meta.MethodOffset;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.meta.PatchedWordConstant;
import java.util.Optional;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

public class SVMHostedValueProvider
extends HostedValuesProvider {
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();

    public SVMHostedValueProvider(AnalysisMetaAccess metaAccess, AnalysisUniverse universe) {
        super(metaAccess, universe);
    }

    public ValueSupplier<JavaConstant> readFieldValue(AnalysisField field, JavaConstant receiver) {
        if (this.fieldValueInterceptionSupport.isValueAvailable(field)) {
            return ValueSupplier.eagerValue((Object)this.doReadValue(field, receiver));
        }
        return ValueSupplier.lazyValue(() -> this.doReadValue(field, receiver), () -> this.fieldValueInterceptionSupport.isValueAvailable(field));
    }

    public JavaConstant readFieldValueWithReplacement(AnalysisField field, JavaConstant receiver) {
        return this.replaceObject(this.doReadValue(field, receiver));
    }

    private JavaConstant doReadValue(AnalysisField field, JavaConstant receiver) {
        VMError.guarantee(!(receiver instanceof SubstrateObjectConstant));
        return this.interceptHosted(this.fieldValueInterceptionSupport.readFieldValue(field, receiver));
    }

    public JavaConstant readArrayElement(JavaConstant array, int index) {
        JavaConstant element = super.readArrayElement(array, index);
        return this.interceptWordType(super.asObject(Object.class, element)).orElse(element);
    }

    public JavaConstant validateReplacedConstant(JavaConstant value) {
        VMError.guarantee(value instanceof PatchedWordConstant || !this.universe.getBigbang().getMetaAccess().isInstanceOf(value, WordBase.class));
        return value;
    }

    public JavaConstant forObject(Object object) {
        AnalysisError.guarantee((!(object instanceof ImageHeapConstant) ? 1 : 0) != 0, (String)"Unexpected ImageHeapConstant %s", (Object[])new Object[]{object});
        return this.interceptWordType(object).orElse(super.forObject(object));
    }

    public <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant instanceof PatchedWordConstant) {
            PatchedWordConstant pwc = (PatchedWordConstant)constant;
            return type.cast(pwc.getWord());
        }
        return (T)super.asObject(type, constant);
    }

    public JavaConstant interceptHosted(JavaConstant constant) {
        if (constant != null && constant.getJavaKind().isObject() && !constant.isNull()) {
            Object original = super.asObject(Object.class, constant);
            if (original instanceof ImageHeapConstant) {
                ImageHeapConstant heapConstant = (ImageHeapConstant)original;
                return heapConstant;
            }
            return this.interceptWordType(original).orElse(constant);
        }
        return constant;
    }

    private Optional<JavaConstant> interceptWordType(Object object) {
        if (object instanceof WordBase) {
            WordBase word = (WordBase)object;
            if (object instanceof RelocatedPointer || object instanceof MethodOffset) {
                return Optional.of(new PatchedWordConstant(word, this.metaAccess.lookupJavaType(object.getClass())));
            }
            return Optional.of(JavaConstant.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)word.rawValue()));
        }
        return Optional.empty();
    }
}

