/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.BuildingInitialLayerPredicate;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.imagelayer.CapnProtoAdapters;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSingletonLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
@AutomaticallyRegisteredImageSingleton(onlyWith={BuildingInitialLayerPredicate.class})
public class SharedLayerBootLayerModulesSingleton
implements LayeredImageSingleton {
    private final Collection<String> sharedBootLayerModules;
    private ModuleLayer bootLayer;

    public SharedLayerBootLayerModulesSingleton() {
        this.sharedBootLayerModules = null;
    }

    private SharedLayerBootLayerModulesSingleton(Collection<String> baseBootLayerModules) {
        this.sharedBootLayerModules = baseBootLayerModules;
    }

    public static SharedLayerBootLayerModulesSingleton singleton() {
        return (SharedLayerBootLayerModulesSingleton)ImageSingletons.lookup(SharedLayerBootLayerModulesSingleton.class);
    }

    public void setBootLayer(ModuleLayer bootLayer) {
        this.bootLayer = bootLayer;
    }

    public Collection<String> getSharedBootLayerModules() {
        return this.sharedBootLayerModules;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        SVMImageLayerWriter.ImageSingletonWriterImpl writerImpl = (SVMImageLayerWriter.ImageSingletonWriterImpl)writer;
        Stream<String> moduleNames = this.bootLayer.modules().stream().map(Module::getName);
        if (this.sharedBootLayerModules != null) {
            moduleNames = Stream.concat(moduleNames, this.sharedBootLayerModules.stream());
        }
        SVMImageLayerWriter.initStringList(writerImpl.getSnapshotBuilder()::initSharedLayerBootLayerModules, moduleNames);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl loaderImpl = (SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl)loader;
        List moduleNames = CapnProtoAdapters.toCollection(loaderImpl.getSnapshotReader().getSharedLayerBootLayerModules(), ArrayList::new);
        return new SharedLayerBootLayerModulesSingleton(moduleNames);
    }
}

