/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;

public interface SharedArenaSupport {
    public static final Class<? extends Annotation> SCOPED_ANNOTATION = ReflectionUtil.lookupClass((String)"jdk.internal.misc.ScopedMemoryAccess$Scoped");

    @Fold
    public static boolean isAvailable() {
        return ImageSingletons.contains(SharedArenaSupport.class);
    }

    @Fold
    public static SharedArenaSupport singleton() {
        return (SharedArenaSupport)ImageSingletons.lookup(SharedArenaSupport.class);
    }

    public BasePhase<MidTierContext> createOptimizeSharedArenaAccessPhase();

    public void registerSafeArenaAccessorClass(AnalysisMetaAccess var1, Class<?> var2);

    public static boolean isScopedMethod(ResolvedJavaMethod method) {
        ResolvedJavaMethod originalMethod = OriginalMethodProvider.getOriginalMethod((ResolvedJavaMethod)method);
        return originalMethod != null && AnnotationAccess.isAnnotationPresent((AnnotatedElement)originalMethod, SCOPED_ANNOTATION);
    }
}

