/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.FutureDefaultsOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.SecurityProvidersSupport;
import com.oracle.svm.core.jdk.ServiceCatalogSupport;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageClassLoaderPostProcessing;
import com.oracle.svm.hosted.analysis.Inflation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.random.RandomGenerator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.hotspot.CompilerConfigurationFactory;
import jdk.graal.compiler.hotspot.HotSpotBackendFactory;
import jdk.graal.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotInvocationPluginProvider;
import jdk.graal.compiler.truffle.hotspot.TruffleCallBoundaryInstrumentationFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;
import sun.util.locale.provider.LocaleDataMetaInfo;

@AutomaticallyRegisteredFeature
public class ServiceLoaderFeature
implements InternalFeature {
    private static final Set<String> SKIPPED_SERVICES = Stream.of(NativeImageClassLoaderPostProcessing.class, Platform.class, RandomGenerator.class, LocaleDataMetaInfo.class, HotSpotJVMCIBackendFactory.class, CompilerConfigurationFactory.class, HotSpotBackendFactory.class, DefaultHotSpotLoweringProvider.Extensions.class, HotSpotInvocationPluginProvider.class, TruffleCallBoundaryInstrumentationFactory.class).map(Class::getName).collect(Collectors.toUnmodifiableSet());
    private final Set<String> servicesToSkip = new HashSet<String>(SKIPPED_SERVICES);
    private static final Set<String> SKIPPED_PROVIDERS = Set.of("jdk.internal.org.jline.JdkConsoleProviderImpl", "jdk.jshell.execution.impl.ConsoleImpl$ConsoleProviderImpl");
    private final Set<String> serviceProvidersToSkip = new HashSet<String>(SKIPPED_PROVIDERS);

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.UseServiceLoaderFeature.getValue();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (!FutureDefaultsOptions.securityProvidersInitializedAtRunTime()) {
            this.servicesToSkip.add(Provider.class.getName());
        }
        this.servicesToSkip.addAll(Options.ServiceLoaderFeatureExcludeServices.getValue().values());
        this.serviceProvidersToSkip.addAll(Options.ServiceLoaderFeatureExcludeServiceProviders.getValue().values());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        accessImpl.imageClassLoader.classLoaderSupport.serviceProvidersForEach((serviceName, providers) -> {
            Class serviceClass = access.findClassByName(serviceName);
            boolean skipService = false;
            Collection providersToSkip = providers;
            if (this.servicesToSkip.contains(serviceName)) {
                skipService = true;
            } else if (serviceClass == null || serviceClass.isArray() || serviceClass.isPrimitive()) {
                skipService = true;
            } else if (!accessImpl.getHostVM().platformSupported(serviceClass)) {
                skipService = true;
            } else {
                providersToSkip = providers.stream().filter(this.serviceProvidersToSkip::contains).collect(Collectors.toList());
                if (!providersToSkip.isEmpty()) {
                    skipService = true;
                }
            }
            if (skipService) {
                ServiceCatalogSupport.singleton().removeServicesFromServicesCatalog((String)serviceName, (Set<String>)new HashSet<String>(providersToSkip));
                return;
            }
            access.registerReachabilityHandler(a -> this.handleServiceClassIsReachable((Feature.DuringAnalysisAccess)a, serviceClass, (Collection<String>)providers), new Object[]{serviceClass});
        });
    }

    void handleServiceClassIsReachable(Feature.DuringAnalysisAccess access, Class<?> serviceProvider, Collection<String> providers) {
        LinkedHashSet<String> registeredProviders = new LinkedHashSet<String>();
        for (String provider : providers) {
            if (this.serviceProvidersToSkip.contains(provider)) continue;
            if (serviceProvider.equals(Provider.class) && !SecurityProvidersSupport.singleton().isUserRequestedSecurityProvider(provider)) {
                SecurityProvidersSupport.singleton().markSecurityProviderAsNotLoaded(provider);
                continue;
            }
            ServiceLoaderFeature.registerProviderForRuntimeReflectionAccess(access, provider, registeredProviders);
        }
        ServiceLoaderFeature.registerProviderForRuntimeResourceAccess(access.getApplicationClassLoader().getUnnamedModule(), serviceProvider.getName(), registeredProviders);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+21/src/java.base/share/classes/java/util/ServiceLoader.java#L745-L793")
    public static void registerProviderForRuntimeReflectionAccess(Feature.DuringAnalysisAccess access, String provider, Set<String> registeredProviders) {
        Class providerClass = access.findClassByName(provider);
        if (providerClass == null || providerClass.isArray() || providerClass.isPrimitive()) {
            return;
        }
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        if (!accessImpl.getHostVM().platformSupported(providerClass)) {
            return;
        }
        if (((Inflation)accessImpl.getBigBang()).getAnnotationSubstitutionProcessor().isDeleted(providerClass)) {
            return;
        }
        Method nullaryProviderMethod = ServiceLoaderFeature.findProviderMethod(providerClass);
        Constructor<?> nullaryConstructor = ServiceLoaderFeature.findNullaryConstructor(providerClass);
        if (nullaryConstructor != null || nullaryProviderMethod != null) {
            RuntimeReflection.register((Class[])new Class[]{providerClass});
            if (nullaryConstructor != null) {
                RuntimeReflection.register((Executable[])new Executable[]{nullaryConstructor});
            } else {
                RuntimeReflection.registerConstructorLookup((Class)providerClass, (Class[])new Class[0]);
            }
            if (nullaryProviderMethod != null) {
                RuntimeReflection.register((Executable[])new Executable[]{nullaryProviderMethod});
            } else {
                RuntimeReflection.registerMethodLookup((Class)providerClass, (String)"provider", (Class[])new Class[0]);
            }
        }
        registeredProviders.add(provider);
    }

    public static void registerProviderForRuntimeResourceAccess(Module module, String serviceProviderName, Set<String> registeredProviders) {
        if (!registeredProviders.isEmpty()) {
            String serviceResourceLocation = "META-INF/services/" + serviceProviderName;
            byte[] serviceFileData = String.join((CharSequence)"\n", registeredProviders).getBytes(StandardCharsets.UTF_8);
            RuntimeResourceAccess.addResource((Module)module, (String)serviceResourceLocation, (byte[])serviceFileData);
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+21/src/java.base/share/classes/java/util/ServiceLoader.java#L620-L631")
    private static Constructor<?> findNullaryConstructor(Class<?> providerClass) {
        Constructor<?> nullaryConstructor = null;
        try {
            Constructor<?> constructor = providerClass.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPublic(constructor.getModifiers())) {
                nullaryConstructor = constructor;
            }
        }
        catch (LinkageError | NoSuchMethodException | SecurityException throwable) {
            // empty catch block
        }
        return nullaryConstructor;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+21/src/java.base/share/classes/java/util/ServiceLoader.java#L583-L612")
    private static Method findProviderMethod(Class<?> providerClass) {
        Method nullaryProviderMethod;
        block4: {
            nullaryProviderMethod = null;
            try {
                if (!providerClass.getModule().isNamed() || providerClass.getModule().getDescriptor().isAutomatic()) break block4;
                for (Method method : providerClass.getDeclaredMethods()) {
                    if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || !method.getName().equals("provider")) continue;
                    if (nullaryProviderMethod == null) {
                        nullaryProviderMethod = method;
                        continue;
                    }
                    nullaryProviderMethod = null;
                    break;
                }
            }
            catch (LinkageError | SecurityException throwable) {
                // empty catch block
            }
        }
        return nullaryProviderMethod;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> UseServiceLoaderFeature = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ServiceLoaderFeatureExcludeServices = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ServiceLoaderFeatureExcludeServiceProviders = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    }
}

