/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.ProtectionDomainSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.security.CodeSource;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class ProtectionDomainFeature
implements InternalFeature {
    private Field executableURLSupplierField;

    ProtectionDomainFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(ProtectionDomainSupport.class, (Object)new ProtectionDomainSupport());
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.executableURLSupplierField = access.findField((Class)ProtectionDomainSupport.class, "executableURLSupplier");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Boolean useApplicationCodeSourceLocation = ProtectionDomainSupport.Options.UseApplicationCodeSourceLocation.getValue();
        if (useApplicationCodeSourceLocation == null) {
            access.registerReachabilityHandler(this::enableCodeSource, new Object[]{ReflectionUtil.lookupMethod(CodeSource.class, (String)"getLocation", (Class[])new Class[0])});
        } else if (useApplicationCodeSourceLocation.booleanValue()) {
            this.enableCodeSource(null);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void enableCodeSource(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        ProtectionDomainSupport.enableCodeSource();
        if (access != null) {
            access.rescanField(ImageSingletons.lookup(ProtectionDomainSupport.class), this.executableURLSupplierField);
        }
    }
}

