/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class Log4ShellFeature
implements InternalFeature {
    private static final String log4jClassName = "org.apache.logging.log4j.Logger";
    private static final String log4jVulnerableErrorMessage = "A vulnerable version of log4j has been detected. Please update to log4j version 2.17.1 or later.%nVulnerable Method(s):";
    private static final String log4jUnknownVersion = "The log4j library has been detected, but the version is unavailable. Due to Log4Shell, please ensure log4j is at version 2.17.1 or later.";
    private static final Set<String> targetMethods = Set.of("debug", "error", "fatal", "info", "log", "trace", "warn");
    private Feature.AfterAnalysisAccess afterAnalysisAccess;

    private static Optional<String> getPomVersion(Class<?> log4jClass) {
        ProtectionDomain pd = log4jClass.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return Optional.empty();
        }
        URL location = cs.getLocation();
        if (location == null) {
            return Optional.empty();
        }
        try {
            ClassLoader nullClassLoader = null;
            FileSystem jarFileSystem = FileSystems.newFileSystem(Paths.get(location.toURI()), nullClassLoader);
            Stream<Path> files = Files.walk(jarFileSystem.getPath("/META-INF", new String[0]), new FileVisitOption[0]);
            return files.filter(file -> file.endsWith("pom.properties")).map(file -> {
                Properties properties = new Properties();
                try {
                    InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                    if (inputStream != null) {
                        properties.load(inputStream);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return properties;
            }).filter(properties -> {
                String groupId = properties.getProperty("groupId");
                String artifactId = properties.getProperty("artifactId");
                return "org.apache.logging.log4j".equals(groupId) && "log4j-core".equals(artifactId);
            }).map(properties -> properties.getProperty("version")).findFirst();
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static boolean vulnerableLog4jOne(String[] components) {
        String minor = components[1];
        return "2".equals(minor);
    }

    private static boolean vulnerableLog4jTwo(String[] components) {
        String minor = components[1];
        if (minor.charAt(0) == '0') {
            return true;
        }
        try {
            int minorVersion = Integer.valueOf(minor);
            if (minorVersion <= 16) {
                return true;
            }
            if (components.length == 3) {
                int patchVersion = Integer.valueOf(components[2]);
                if (minorVersion == 17 && patchVersion == 0) {
                    return true;
                }
            }
        }
        catch (NumberFormatException ex) {
            LogUtils.warning((String)log4jUnknownVersion);
        }
        return false;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.afterAnalysisAccess = access;
    }

    /*
     * WARNING - void declaration
     */
    public String getUserWarning() {
        Optional<String> pomVersion;
        Class log4jClass = this.afterAnalysisAccess.findClassByName(log4jClassName);
        if (log4jClass == null) {
            return null;
        }
        Package log4jPackage = log4jClass.getPackage();
        String version = log4jPackage.getImplementationVersion();
        if (version == null && (pomVersion = Log4ShellFeature.getPomVersion(log4jClass)).isPresent()) {
            version = pomVersion.get();
        }
        if (version == null) {
            return log4jUnknownVersion;
        }
        String[] components = version.split("\\.");
        if (components.length < 2) {
            return log4jUnknownVersion;
        }
        HashSet<CallSite> vulnerableMethods = new HashSet<CallSite>();
        if ("1".equals(components[0]) && Log4ShellFeature.vulnerableLog4jOne(components) || "2".equals(components[0]) && Log4ShellFeature.vulnerableLog4jTwo(components)) {
            void var8_10;
            Method[] methodArray = log4jClass.getMethods();
            int n = methodArray.length;
            boolean bl = false;
            while (var8_10 < n) {
                Method method = methodArray[var8_10];
                String methodName = method.getName();
                if (targetMethods.contains(methodName) && (this.afterAnalysisAccess.isReachable((Executable)method) || this.afterAnalysisAccess.reachableMethodOverrides((Executable)method).size() > 0)) {
                    vulnerableMethods.add((CallSite)((Object)(method.getDeclaringClass().getName() + "." + method.getName())));
                }
                ++var8_10;
            }
        }
        if (vulnerableMethods.size() == 0) {
            return null;
        }
        StringBuilder renderedErrorMessage = new StringBuilder(String.format(log4jVulnerableErrorMessage, new Object[0]));
        for (String string : vulnerableMethods) {
            renderedErrorMessage.append(System.lineSeparator() + "    - " + string);
        }
        return renderedErrorMessage.toString();
    }
}

