/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticallyRegisteredFeature
public class HKDFSupportFeature
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class[] hkdfClasses = new Class[]{ReflectionUtil.lookupClass((String)"com.sun.crypto.provider.HKDFKeyDerivation$HKDFSHA256"), ReflectionUtil.lookupClass((String)"com.sun.crypto.provider.HKDFKeyDerivation$HKDFSHA384"), ReflectionUtil.lookupClass((String)"com.sun.crypto.provider.HKDFKeyDerivation$HKDFSHA512")};
        access.registerReachabilityHandler(duringAnalysisAccess -> {
            for (Class hkdf : hkdfClasses) {
                RuntimeReflection.register((Class[])new Class[]{hkdf});
                RuntimeReflection.register((Executable[])hkdf.getConstructors());
            }
        }, new Object[]{ReflectionUtil.lookupClass((String)"javax.crypto.KDF")});
    }
}

