/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.graal.isolated.ClientHandle;
import com.oracle.svm.core.graal.isolated.ClientIsolateThread;
import com.oracle.svm.core.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.core.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.EncodedSpeculationReason;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.graal.isolated.IsolatedSpeculationReason;
import com.oracle.svm.graal.isolated.IsolatedSpeculationReasonEncoding;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import jdk.graal.compiler.serviceprovider.UnencodedSpeculationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

public final class IsolatedSpeculationLog
extends IsolatedObjectProxy<SpeculationLog>
implements SpeculationLog {
    public IsolatedSpeculationLog(ClientHandle<SpeculationLog> logHandle) {
        super(logHandle);
    }

    public void collectFailedSpeculations() {
        IsolatedSpeculationLog.collectFailedSpeculations0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    private static byte[] encodeAsByteArray(SpeculationLog.SpeculationReason reason) {
        int groupId = 0;
        Object[] context = null;
        try {
            Field contextField;
            Field groupIdField;
            if (reason instanceof UnencodedSpeculationReason) {
                Class<UnencodedSpeculationReason> klass = UnencodedSpeculationReason.class;
                groupIdField = klass.getDeclaredField("groupId");
                contextField = klass.getDeclaredField("context");
            } else {
                Class<?> klass = Class.forName("jdk.vm.ci.meta.EncodedSpeculationReason");
                groupIdField = klass.getDeclaredField("groupId");
                contextField = klass.getDeclaredField("context");
            }
            groupIdField.setAccessible(true);
            groupId = groupIdField.getInt(reason);
            contextField.setAccessible(true);
            context = (Object[])contextField.get(reason);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            VMError.shouldNotReachHere("Failed to encode speculation reason", e);
        }
        IsolatedSpeculationReasonEncoding encoding = IsolatedSpeculationLog.encode(groupId, context);
        return encoding.getByteArray();
    }

    private static IsolatedSpeculationReasonEncoding encode(int groupId, Object[] context) {
        IsolatedSpeculationReasonEncoding encoding = new IsolatedSpeculationReasonEncoding();
        encoding.addInt(groupId);
        for (Object o : context) {
            if (o == null) {
                encoding.addInt(0);
                continue;
            }
            IsolatedSpeculationLog.addNonNullObject(encoding, o);
        }
        return encoding;
    }

    private static void addNonNullObject(IsolatedSpeculationReasonEncoding encoding, Object o) {
        Class<?> c = o.getClass();
        if (c == String.class) {
            encoding.addString((String)o);
        } else if (c == Byte.class) {
            encoding.addByte(((Byte)o).byteValue());
        } else if (c == Short.class) {
            encoding.addShort(((Short)o).shortValue());
        } else if (c == Character.class) {
            encoding.addShort(((Character)o).charValue());
        } else if (c == Integer.class) {
            encoding.addInt((Integer)o);
        } else if (c == Long.class) {
            encoding.addLong((Long)o);
        } else if (c == Float.class) {
            encoding.addInt(Float.floatToRawIntBits(((Float)o).floatValue()));
        } else if (c == Double.class) {
            encoding.addLong(Double.doubleToRawLongBits((Double)o));
        } else if (o instanceof Enum) {
            encoding.addInt(((Enum)o).ordinal());
        } else if (o instanceof ResolvedJavaMethod) {
            encoding.addMethod((ResolvedJavaMethod)o);
        } else if (o instanceof ResolvedJavaType) {
            encoding.addType((ResolvedJavaType)o);
        } else if (o instanceof ResolvedJavaField) {
            encoding.addField((ResolvedJavaField)o);
        } else {
            throw new IllegalArgumentException("Unsupported type for encoding: " + c.getName());
        }
    }

    public boolean maySpeculate(SpeculationLog.SpeculationReason reason) {
        byte[] bytes = IsolatedSpeculationLog.encodeAsByteArray(reason);
        try (PrimitiveArrayView refBytes = PrimitiveArrayView.createForReading(bytes);){
            boolean bl = IsolatedSpeculationLog.maySpeculate0(IsolatedCompileContext.get().getClient(), this.handle, refBytes.addressOfArrayElement(0), bytes.length);
            return bl;
        }
    }

    public SpeculationLog.Speculation speculate(SpeculationLog.SpeculationReason reason) {
        ClientHandle<SpeculationLog.SpeculationReason> reasonHandle;
        byte[] bytes = IsolatedSpeculationLog.encodeAsByteArray(reason);
        try (PrimitiveArrayView refBytes = PrimitiveArrayView.createForReading(bytes);){
            reasonHandle = IsolatedSpeculationLog.speculate0(IsolatedCompileContext.get().getClient(), this.handle, refBytes.addressOfArrayElement(0), bytes.length);
        }
        return new SubstrateSpeculationLog.SubstrateSpeculation(new IsolatedSpeculationReason(reasonHandle));
    }

    public boolean hasSpeculations() {
        return IsolatedSpeculationLog.hasSpeculations0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public SpeculationLog.Speculation lookupSpeculation(JavaConstant constant) {
        throw VMError.shouldNotReachHere("not required");
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static void collectFailedSpeculations0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle) {
        IsolatedCompileClient.get().unhand(logHandle).collectFailedSpeculations();
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean hasSpeculations0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle) {
        return IsolatedCompileClient.get().unhand(logHandle).hasSpeculations();
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean maySpeculate0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle, PointerBase arrayData, int length) {
        byte[] bytes = new byte[length];
        ByteBuffer.wrap(bytes).put(CTypeConversion.asByteBuffer((PointerBase)arrayData, (int)length));
        SpeculationLog log = IsolatedCompileClient.get().unhand(logHandle);
        return log.maySpeculate((SpeculationLog.SpeculationReason)new EncodedSpeculationReason(bytes));
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static ClientHandle<SpeculationLog.SpeculationReason> speculate0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle, PointerBase arrayData, int length) {
        byte[] bytes = new byte[length];
        ByteBuffer.wrap(bytes).put(CTypeConversion.asByteBuffer((PointerBase)arrayData, (int)length));
        SpeculationLog log = IsolatedCompileClient.get().unhand(logHandle);
        EncodedSpeculationReason encodedReason = new EncodedSpeculationReason(bytes);
        SpeculationLog.Speculation speculation = log.speculate((SpeculationLog.SpeculationReason)encodedReason);
        SpeculationLog.SpeculationReason reason = speculation.getReason();
        assert (speculation.equals((Object)new SubstrateSpeculationLog.SubstrateSpeculation(reason)));
        return IsolatedCompileClient.get().hand(reason);
    }
}

