/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jdk.graal.compiler.core.gen.NodeMatchRules;
import jdk.graal.compiler.core.match.MatchStatement;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.phases.BasePhase;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

public class GraalCompilerSupport {
    public final EconomicMap<Class<?>, NodeClass<?>> nodeClasses = ImageHeapMap.create("nodeClasses");
    public final EconomicMap<Class<?>, LIRInstructionClass<?>> instructionClasses = ImageHeapMap.create("instructionClasses");
    public HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry;
    protected EconomicMap<Class<?>, BasePhase.BasePhaseStatistics> basePhaseStatistics;
    protected EconomicMap<Class<?>, LIRPhase.LIRPhaseStatistics> lirPhaseStatistics;
    protected final List<DebugHandlersFactory> debugHandlersFactories = new ArrayList<DebugHandlersFactory>();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public GraalCompilerSupport() {
        for (DebugHandlersFactory c : DebugHandlersFactory.LOADER) {
            this.debugHandlersFactories.add(c);
        }
    }

    public HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> getMatchRuleRegistry() {
        return this.matchRuleRegistry;
    }

    public void setMatchRuleRegistry(HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry) {
        this.matchRuleRegistry = matchRuleRegistry;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void allocatePhaseStatisticsCache() {
        GraalCompilerSupport.get().basePhaseStatistics = ImageHeapMap.create("basePhaseStatistics");
        GraalCompilerSupport.get().lirPhaseStatistics = ImageHeapMap.create("lirPhaseStatistics");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerPhaseStatistics(Feature.DuringAnalysisAccess a, Class<?> newlyReachableClass) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (!Modifier.isAbstract(newlyReachableClass.getModifiers())) {
            if (BasePhase.class.isAssignableFrom(newlyReachableClass)) {
                GraalCompilerSupport.registerStatistics(newlyReachableClass, GraalCompilerSupport.get().basePhaseStatistics, new BasePhase.BasePhaseStatistics(newlyReachableClass), access);
            } else if (LIRPhase.class.isAssignableFrom(newlyReachableClass)) {
                GraalCompilerSupport.registerStatistics(newlyReachableClass, GraalCompilerSupport.get().lirPhaseStatistics, new LIRPhase.LIRPhaseStatistics(newlyReachableClass), access);
            }
        }
    }

    private static <S> void registerStatistics(Class<?> phaseSubClass, EconomicMap<Class<?>, S> cache, S newStatistics, FeatureImpl.DuringAnalysisAccessImpl access) {
        assert (!cache.containsKey(phaseSubClass));
        cache.put(phaseSubClass, newStatistics);
        access.requireAnalysisIteration();
    }

    public static GraalCompilerSupport get() {
        return (GraalCompilerSupport)ImageSingletons.lookup(GraalCompilerSupport.class);
    }

    public EconomicMap<Class<?>, BasePhase.BasePhaseStatistics> getBasePhaseStatistics() {
        return this.basePhaseStatistics;
    }

    public EconomicMap<Class<?>, LIRPhase.LIRPhaseStatistics> getLirPhaseStatistics() {
        return this.lirPhaseStatistics;
    }

    public List<DebugHandlersFactory> getDebugHandlersFactories() {
        return this.debugHandlersFactories;
    }
}

