/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.os.AbstractRawFileOperationSupport;
import com.oracle.svm.core.posix.PosixRawFileOperationSupport;
import java.nio.ByteOrder;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class PosixRawFileOperationFeature
implements InternalFeature {
    PosixRawFileOperationFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ByteOrder nativeByteOrder = ByteOrder.nativeOrder();
        assert (nativeByteOrder == ByteOrder.LITTLE_ENDIAN || nativeByteOrder == ByteOrder.BIG_ENDIAN);
        PosixRawFileOperationSupport littleEndian = new PosixRawFileOperationSupport(ByteOrder.LITTLE_ENDIAN == nativeByteOrder);
        PosixRawFileOperationSupport bigEndian = new PosixRawFileOperationSupport(ByteOrder.BIG_ENDIAN == nativeByteOrder);
        PosixRawFileOperationSupport nativeOrder = nativeByteOrder == ByteOrder.LITTLE_ENDIAN ? littleEndian : bigEndian;
        ImageSingletons.add(AbstractRawFileOperationSupport.RawFileOperationSupportHolder.class, (Object)new AbstractRawFileOperationSupport.RawFileOperationSupportHolder(littleEndian, bigEndian, nativeOrder));
    }
}

