/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes.foreign;

import com.oracle.svm.core.nodes.ClusterNode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.debug.SideEffectNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.internal.foreign.MemorySessionImpl;
import jdk.internal.misc.ScopedMemoryAccess;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public abstract class ScopedMemExceptionHandlerClusterNode
extends FixedWithNextNode
implements ClusterNode {
    public static final NodeClass<ScopedMemExceptionHandlerClusterNode> TYPE = NodeClass.create(ScopedMemExceptionHandlerClusterNode.class);

    public ScopedMemExceptionHandlerClusterNode(NodeClass<? extends FixedWithNextNode> c, Stamp stamp) {
        super(c, stamp);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
    public static class ClusterBeginNode
    extends ScopedMemExceptionHandlerClusterNode
    implements LIRLowerable {
        public static final NodeClass<ClusterBeginNode> TYPE = NodeClass.create(ClusterBeginNode.class);
        @Node.OptionalInput
        ValueNode scope;

        public ClusterBeginNode(ValueNode scope) {
            super(TYPE, StampFactory.forVoid());
            this.scope = scope;
        }

        public void generate(NodeLIRBuilderTool generator) {
        }

        @Node.NodeIntrinsic
        public static native void beginExceptionCluster(long var0);

        @Override
        public void delete() {
            GraphUtil.unlinkFixedNode((FixedWithNextNode)this);
            this.safeDelete();
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN, allowedUsageTypes={InputType.Memory})
    public static class ExceptionPathNode
    extends ScopedMemExceptionHandlerClusterNode
    implements LIRLowerable,
    SingleMemoryKill,
    MemoryAccess {
        public static final NodeClass<ExceptionPathNode> TYPE = NodeClass.create(ExceptionPathNode.class);
        @Node.OptionalInput
        ValueNode exception;
        @Node.OptionalInput
        ValueNode scope;
        @Node.OptionalInput(value=InputType.Memory)
        MemoryKill lastLocationAccess;

        public ExceptionPathNode(ValueNode exception, ValueNode scope) {
            super(TYPE, exception.stamp(NodeView.DEFAULT));
            this.exception = exception;
            this.scope = scope;
        }

        public ValueNode getException() {
            return this.exception;
        }

        public ValueNode getScope() {
            return this.scope;
        }

        public void generate(NodeLIRBuilderTool generator) {
        }

        @Node.NodeIntrinsic
        public static native ScopedMemoryAccess.ScopedAccessError endClusterExceptionPath(Throwable var0, long var1);

        @Override
        public void delete() {
            if (this.hasUsagesOfType(InputType.Memory) && this.lastLocationAccess == null) {
                StructuredGraph g = this.graph();
                SideEffectNode sf = (SideEffectNode)g.addWithoutUnique((Node)new SideEffectNode());
                g.addBeforeFixed((FixedNode)this, (FixedWithNextNode)sf);
                this.replaceAtUsages((Node)sf, InputType.Memory);
            }
            this.replaceAtUsages((Node)this.exception);
            GraphUtil.unlinkFixedNode((FixedWithNextNode)this);
            this.safeDelete();
        }

        public LocationIdentity getKilledLocationIdentity() {
            return LocationIdentity.ANY_LOCATION;
        }

        public LocationIdentity getLocationIdentity() {
            return this.getKilledLocationIdentity();
        }

        public MemoryKill getLastLocationAccess() {
            return this.lastLocationAccess;
        }

        public void setLastLocationAccess(MemoryKill lla) {
            this.updateUsagesInterface((ValueNodeInterface)this.lastLocationAccess, (ValueNodeInterface)lla);
            this.lastLocationAccess = lla;
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
    public static class ExceptionInputNode
    extends ScopedMemExceptionHandlerClusterNode
    implements LIRLowerable {
        public static final NodeClass<ExceptionInputNode> TYPE = NodeClass.create(ExceptionInputNode.class);
        @Node.OptionalInput
        ValueNode scope;
        @Node.OptionalInput
        ValueNode input;

        public ExceptionInputNode(ValueNode scope, ValueNode input) {
            super(TYPE, input.stamp(NodeView.DEFAULT));
            this.input = input;
            this.scope = scope;
        }

        public ValueNode getInput() {
            return this.input;
        }

        public void generate(NodeLIRBuilderTool generator) {
        }

        @Node.NodeIntrinsic
        public static native MemorySessionImpl clusterInputValue(long var0, MemorySessionImpl var2);

        @Override
        public void delete() {
            this.replaceAtUsages((Node)this.input);
            GraphUtil.unlinkFixedNode((FixedWithNextNode)this);
            this.safeDelete();
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
    public static class RegularPathNode
    extends ScopedMemExceptionHandlerClusterNode
    implements LIRLowerable {
        public static final NodeClass<RegularPathNode> TYPE = NodeClass.create(RegularPathNode.class);
        @Node.OptionalInput
        ValueNode scope;

        public RegularPathNode(ValueNode scope) {
            super(TYPE, StampFactory.forVoid());
            this.scope = scope;
        }

        public ValueNode getScope() {
            return this.scope;
        }

        public void generate(NodeLIRBuilderTool generator) {
        }

        @Node.NodeIntrinsic
        public static native void endClusterNormalPath(long var0);

        @Override
        public void delete() {
            GraphUtil.unlinkFixedNode((FixedWithNextNode)this);
            this.safeDelete();
        }
    }
}

