/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes.foreign;

import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchored;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.internal.foreign.MemorySessionImpl;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public class MemoryArenaValidInScopeNode
extends FixedWithNextNode
implements MemoryAccess,
ControlFlowAnchored {
    public static final Field STATE_FIELD = ReflectionUtil.lookupField(MemorySessionImpl.class, (String)"state");
    public static final NodeClass<MemoryArenaValidInScopeNode> TYPE = NodeClass.create(MemoryArenaValidInScopeNode.class);
    @Node.OptionalInput
    ValueNode value;
    private final LocationIdentity fieldLocation;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;
    @Node.OptionalInput
    NodeInputList<ValueNode> scopeAssociatedValues;

    public MemoryArenaValidInScopeNode(ValueNode value, LocationIdentity fieldLocation) {
        super(TYPE, (Stamp)StampFactory.forInteger((int)64));
        this.value = value;
        this.fieldLocation = fieldLocation;
    }

    public void addScopeAssociatedValue(ValueNode memorySession) {
        if (this.scopeAssociatedValues == null) {
            this.scopeAssociatedValues = new NodeInputList((Node)this);
        }
        this.scopeAssociatedValues.add((Object)memorySession);
    }

    public ValueNode getValue() {
        return this.value;
    }

    public void delete(int val) {
        this.replaceAtUsages((Node)ConstantNode.forLong((long)val, (StructuredGraph)this.graph()));
        this.graph().removeFixed((FixedWithNextNode)this);
    }

    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface((ValueNodeInterface)this.lastLocationAccess, (ValueNodeInterface)lla);
        this.lastLocationAccess = lla;
    }

    public LocationIdentity getLocationIdentity() {
        return this.fieldLocation;
    }
}

