/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.methodhandles;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_MethodHandleNatives_Constants;
import com.oracle.svm.core.methodhandles.Util_java_lang_invoke_MethodHandleNatives;
import com.oracle.svm.core.reflect.UnsafeFieldUtil;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Field;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@TargetClass(className="java.lang.invoke.MethodHandleNatives")
public final class Target_java_lang_invoke_MethodHandleNatives {
    @Substitute
    private static void init(Target_java_lang_invoke_MemberName self, Object ref) {
        byte refKind;
        Object[] type;
        Member member = (Member)ref;
        if (member instanceof Field) {
            Field field = (Field)member;
            type = field.getType();
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_FIELD | field.getModifiers();
            refKind = Modifier.isStatic(field.getModifiers()) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getStatic : Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getField;
        } else if (member instanceof Method) {
            Method method = (Method)member;
            Object[] typeInfo = new Object[]{method.getReturnType(), method.getParameterTypes()};
            type = typeInfo;
            int mods = method.getModifiers();
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_METHOD | mods;
            refKind = Modifier.isStatic(mods) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeStatic : (Modifier.isInterface(mods) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeInterface : Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeVirtual);
        } else if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            Object[] typeInfo = new Object[]{Void.TYPE, constructor.getParameterTypes()};
            type = typeInfo;
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_CONSTRUCTOR | constructor.getModifiers();
            refKind = Target_java_lang_invoke_MethodHandleNatives_Constants.REF_newInvokeSpecial;
        } else {
            throw new InternalError("Unknown member type: " + String.valueOf(member.getClass()));
        }
        self.init(member.getDeclaringClass(), member.getName(), type, flags |= refKind << Target_java_lang_invoke_MethodHandleNatives_Constants.MN_REFERENCE_KIND_SHIFT);
        self.reflectAccess = (Member)ref;
    }

    @Substitute
    private static void expand(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.expand()");
    }

    @Substitute
    private static long objectFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null && self.intrinsic == null) {
            throw new InternalError("Unresolved field");
        }
        if (!self.isField() || self.isStatic()) {
            throw new InternalError("Non-static field required");
        }
        if (self.intrinsic != null) {
            return -1L;
        }
        return UnsafeFieldUtil.getFieldOffset(SubstrateUtil.cast(self.reflectAccess, Target_java_lang_reflect_Field.class));
    }

    @Substitute
    private static long staticFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null && self.intrinsic == null) {
            throw new InternalError("Unresolved field");
        }
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("Static field required");
        }
        if (self.intrinsic != null) {
            return -1L;
        }
        return UnsafeFieldUtil.getFieldOffset(SubstrateUtil.cast(self.reflectAccess, Target_java_lang_reflect_Field.class));
    }

    @Substitute
    private static Object staticFieldBase(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null) {
            throw new InternalError("Unresolved field");
        }
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("Static field required");
        }
        Field field = (Field)self.reflectAccess;
        int layerNumber = ImageLayerBuildingSupport.buildingImageLayer() ? SubstrateUtil.cast((Object)field, Target_java_lang_reflect_Field.class).installedLayerNumber : -1;
        if (field.getType().isPrimitive()) {
            return StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(layerNumber);
        }
        return StaticFieldsSupport.getStaticObjectFieldsAtRuntime(layerNumber);
    }

    @Substitute
    private static Object getMemberVMInfo(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.getMemberVMInfo()");
    }

    @Delete
    private static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    @Delete
    private static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    @Delete
    private static native void registerNatives();

    @Delete
    private static native int getNamedCon(int var0, Object[] var1);

    @Delete
    private static native void copyOutBootstrapArguments(Class<?> var0, int[] var1, int var2, int var3, Object[] var4, int var5, boolean var6, Object var7);

    @AnnotateOriginal
    static native boolean refKindIsMethod(byte var0);

    @AnnotateOriginal
    static native String refKindName(byte var0);

    @Substitute
    public static Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName self, Class<?> caller, int lookupMode, boolean speculativeResolve) throws LinkageError, ClassNotFoundException {
        Class<?> declaringClass = self.getDeclaringClass();
        Target_java_lang_invoke_MemberName resolved = Util_java_lang_invoke_MethodHandleNatives.resolve(self, caller, speculativeResolve);
        assert (resolved == null || resolved.reflectAccess != null || resolved.intrinsic != null);
        if (resolved != null && resolved.reflectAccess != null && caller != null && !Util_java_lang_invoke_MethodHandleNatives.verifyAccess(declaringClass, resolved.reflectAccess.getDeclaringClass(), resolved.reflectAccess.getModifiers(), caller, lookupMode)) {
            throw new IllegalAccessError(String.valueOf(resolved) + " is not accessible from " + String.valueOf(caller));
        }
        return resolved;
    }

    @Delete
    static native MethodHandle linkMethodHandleConstant(Class<?> var0, int var1, Class<?> var2, String var3, Object var4);
}

