/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.metadata;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.RuntimeSupportFeature;
import com.oracle.svm.core.metadata.MetadataTracer;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class MetadataTracerFeature
implements InternalFeature {
    MetadataTracerFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(RuntimeSupportFeature.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (MetadataTracer.Options.MetadataTracingSupport.getValue().booleanValue()) {
            ImageSingletons.add(MetadataTracer.class, (Object)new MetadataTracer());
            RuntimeSupport.getRuntimeSupport().addInitializationHook(MetadataTracer.initializeMetadataTracingHook());
            RuntimeSupport.getRuntimeSupport().addTearDownHook(MetadataTracer.shutDownMetadataTracingHook());
        } else {
            RuntimeSupport.getRuntimeSupport().addInitializationHook(MetadataTracer.checkImproperOptionUsageHook());
        }
    }
}

