/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.util.VMError;
import java.util.Objects;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.ComparableWord;

public final class MethodPointer
implements CFunctionPointer {
    private final ResolvedJavaMethod method;
    private final boolean permitsRewriteToPLT;

    public MethodPointer(ResolvedJavaMethod method, boolean permitsRewriteToPLT) {
        Objects.requireNonNull(method);
        this.method = method;
        this.permitsRewriteToPLT = permitsRewriteToPLT;
    }

    public MethodPointer(ResolvedJavaMethod method) {
        this(method, true);
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public boolean permitsRewriteToPLT() {
        return this.permitsRewriteToPLT;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNonNull() {
        return true;
    }

    public long rawValue() {
        throw VMError.shouldNotReachHere("must not be called in hosted mode");
    }

    public boolean equal(ComparableWord val) {
        throw VMError.shouldNotReachHere("must not be called in hosted mode");
    }

    public boolean notEqual(ComparableWord val) {
        throw VMError.shouldNotReachHere("must not be called in hosted mode");
    }
}

