/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.libgraal;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.libgraal.LibGraalBuild;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.libgraal.impl.LibGraalRuntimeSupport;

@AutomaticallyRegisteredImageSingleton(value={LibGraalRuntimeSupport.class}, onlyWith={LibGraalBuild.class})
public final class LibGraalRuntimeSupportImpl
implements LibGraalRuntimeSupport {
    public void processReferences() {
        Heap.getHeap().doReferenceHandling();
    }

    public void notifyLowMemoryPoint(boolean suggestFullGC) {
        Heap.getHeap().getGC().collectionHint(suggestFullGC);
    }

    public long getIsolateID() {
        return Isolates.getIsolateId();
    }

    public void fatalError(String message) {
        throw VMError.shouldNotReachHere(message);
    }
}

