/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.jvmti.JvmtiCapabilitiesUtil;
import com.oracle.svm.core.jvmti.JvmtiEnv;
import com.oracle.svm.core.jvmti.JvmtiEventCallbacksUtil;
import com.oracle.svm.core.jvmti.JvmtiFunctionTable;
import com.oracle.svm.core.jvmti.headers.JvmtiCapabilities;
import com.oracle.svm.core.jvmti.headers.JvmtiError;
import com.oracle.svm.core.jvmti.headers.JvmtiEvent;
import com.oracle.svm.core.jvmti.headers.JvmtiEventCallbacks;
import com.oracle.svm.core.jvmti.headers.JvmtiExternalEnv;
import com.oracle.svm.core.jvmti.headers.JvmtiInterface;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public final class JvmtiEnvUtil {
    private static final int VALID_ENV_MAGIC = 29166;
    private static final int DISPOSED_ENV_MAGIC = 57084;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JvmtiEnvUtil() {
    }

    static JvmtiEnv allocate() {
        JvmtiInterface functionTable = JvmtiFunctionTable.allocateFunctionTable();
        if (functionTable.isNull()) {
            return (JvmtiEnv)Word.nullPointer();
        }
        JvmtiEnv env = (JvmtiEnv)NullableNativeMemory.calloc(Word.unsigned((int)JvmtiEnvUtil.internalEnvSize()), NmtCategory.JVMTI);
        if (env.isNull()) {
            JvmtiFunctionTable.freeFunctionTable(functionTable);
            return (JvmtiEnv)Word.nullPointer();
        }
        env.setIsolate(CurrentIsolate.getIsolate());
        env.setMagic(29166);
        JvmtiExternalEnv externalEnv = JvmtiEnvUtil.toExternal(env);
        externalEnv.setFunctions(functionTable);
        return env;
    }

    static void dispose(JvmtiEnv env) {
        JvmtiCapabilities capabilities = JvmtiEnvUtil.getCapabilities(env);
        JvmtiEnvUtil.relinquishCapabilities(capabilities);
        env.setMagic(57084);
    }

    static void free(JvmtiEnv env) {
        JvmtiExternalEnv externalEnv = JvmtiEnvUtil.toExternal(env);
        JvmtiFunctionTable.freeFunctionTable(externalEnv.getFunctions());
        externalEnv.setFunctions((JvmtiInterface)Word.nullPointer());
        NullableNativeMemory.free(env);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JvmtiEnv toInternal(JvmtiExternalEnv externalEnv) {
        assert (externalEnv.isNonNull());
        return (JvmtiEnv)((Pointer)externalEnv).subtract(JvmtiEnvUtil.externalEnvOffset());
    }

    public static JvmtiExternalEnv toExternal(JvmtiEnv env) {
        assert (env.isNonNull());
        return (JvmtiExternalEnv)((Pointer)env).add(JvmtiEnvUtil.externalEnvOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isValid(JvmtiEnv env) {
        assert (env.isNonNull());
        return env.getMagic() == 29166;
    }

    public static boolean isDead(JvmtiEnv env) {
        return env.getMagic() == 57084;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Isolate getIsolate(JvmtiEnv env) {
        assert (JvmtiEnvUtil.isValid(env));
        return env.getIsolate();
    }

    public static JvmtiCapabilities getCapabilities(JvmtiEnv env) {
        assert (JvmtiEnvUtil.isValid(env));
        return (JvmtiCapabilities)JvmtiEnvUtil.addOffset(env, JvmtiEnvUtil.capabilitiesOffset());
    }

    public static JvmtiError addCapabilities(JvmtiCapabilities capabilities) {
        assert (capabilities.isNonNull());
        if (JvmtiCapabilitiesUtil.hasAny(capabilities)) {
            return JvmtiError.JVMTI_ERROR_NOT_AVAILABLE;
        }
        return JvmtiError.JVMTI_ERROR_NONE;
    }

    public static JvmtiError relinquishCapabilities(JvmtiCapabilities capabilities) {
        assert (capabilities.isNonNull());
        return JvmtiError.JVMTI_ERROR_NONE;
    }

    static JvmtiEventCallbacks getEventCallbacks(JvmtiEnv env) {
        assert (JvmtiEnvUtil.isValid(env));
        return (JvmtiEventCallbacks)JvmtiEnvUtil.addOffset(env, JvmtiEnvUtil.eventCallbacksOffset());
    }

    public static void setEventCallbacks(JvmtiEnv env, JvmtiEventCallbacks newCallbacks, int sizeOfCallbacks) {
        JvmtiEventCallbacks eventCallbacks = JvmtiEnvUtil.getEventCallbacks(env);
        JvmtiEventCallbacksUtil.setEventCallbacks(eventCallbacks, newCallbacks, sizeOfCallbacks);
    }

    public static boolean hasEventCapability() {
        return true;
    }

    public static void setEventUserEnabled(JvmtiEnv env, Thread javaEventThread, JvmtiEvent eventType, boolean value) {
        assert (javaEventThread == null) : "thread-local events are not supported at the moment";
        long enabledBits = env.getEventUserEnabled();
        long bit = JvmtiEvent.getBit(eventType);
        enabledBits = value ? (enabledBits |= bit) : (enabledBits &= bit ^ 0xFFFFFFFFFFFFFFFFL);
        env.setEventUserEnabled(enabledBits);
    }

    public static boolean isEventEnabled(JvmtiEnv env, JvmtiEvent eventType) {
        return (env.getEventUserEnabled() & JvmtiEvent.getBit(eventType)) != 0L;
    }

    private static <T extends PointerBase> T addOffset(JvmtiEnv env, int offset) {
        return (T)((Pointer)env).add(offset);
    }

    @Fold
    static int capabilitiesOffset() {
        return NumUtil.roundUp((int)SizeOf.get(JvmtiEnv.class), (int)ConfigurationValues.getTarget().wordSize);
    }

    @Fold
    static int eventCallbacksOffset() {
        return NumUtil.roundUp((int)(JvmtiEnvUtil.capabilitiesOffset() + SizeOf.get(JvmtiCapabilities.class)), (int)ConfigurationValues.getTarget().wordSize);
    }

    @Fold
    static int externalEnvOffset() {
        return NumUtil.roundUp((int)(JvmtiEnvUtil.eventCallbacksOffset() + SizeOf.get(JvmtiEventCallbacks.class)), (int)ConfigurationValues.getTarget().wordSize);
    }

    @Fold
    static int internalEnvSize() {
        return JvmtiEnvUtil.externalEnvOffset() + SizeOf.get(JvmtiExternalEnv.class);
    }
}

