/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.jvmti.headers.JvmtiCapabilities;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;

public final class JvmtiCapabilitiesUtil {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JvmtiCapabilitiesUtil() {
    }

    public static boolean hasAny(JvmtiCapabilities capabilities) {
        assert (capabilities.isNonNull());
        Pointer rawData = (Pointer)capabilities;
        for (int i = 0; i < SizeOf.get(JvmtiCapabilities.class); ++i) {
            if (rawData.readByte(i) == 0) continue;
            return true;
        }
        return false;
    }

    public static void clear(JvmtiCapabilities capabilities) {
        assert (capabilities.isNonNull());
        UnmanagedMemoryUtil.fill((Pointer)capabilities, SizeOf.unsigned(JvmtiCapabilities.class), (byte)0);
    }

    public static void copy(JvmtiCapabilities src, JvmtiCapabilities dst) {
        UnmanagedMemoryUtil.copyForward((Pointer)src, (Pointer)dst, SizeOf.unsigned(JvmtiCapabilities.class));
    }
}

