/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import org.graalvm.nativeimage.StackValue;

public final class ExecutionSampleEvent {
    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void writeExecutionSample(long elapsedTicks, long threadId, long stackTraceId, long threadState) {
        if (JfrEvent.ExecutionSample.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.ExecutionSample);
            JfrNativeEventWriter.putLong(data, elapsedTicks);
            JfrNativeEventWriter.putThread(data, threadId);
            JfrNativeEventWriter.putLong(data, stackTraceId);
            JfrNativeEventWriter.putLong(data, threadState);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

