/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

public class AllocationRequiringGCEvent {
    public static void emit(UnsignedWord gcId, UnsignedWord size) {
        if (HasJfrSupport.get()) {
            AllocationRequiringGCEvent.emit0(gcId, size);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emit0(UnsignedWord gcId, UnsignedWord size) {
        if (JfrEvent.AllocationRequiringGC.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.AllocationRequiringGC);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(JfrEvent.AllocationRequiringGC));
            JfrNativeEventWriter.putLong(data, gcId.rawValue());
            JfrNativeEventWriter.putLong(data, size.rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

