/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.collections.AbstractUninterruptibleHashtable;
import com.oracle.svm.core.collections.UninterruptibleEntry;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrRepository;
import com.oracle.svm.core.jfr.JfrStackWalker;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.jfr.utils.JfrVisited;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.sampler.SamplerSampleWriterDataAccess;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public class JfrStackTraceRepository
implements JfrRepository {
    private static final int DEFAULT_STACK_DEPTH = 64;
    private static final int MIN_STACK_DEPTH = 1;
    private static final int MAX_STACK_DEPTH = 2048;
    private final VMMutex mutex = new VMMutex("jfrStackTraceRepository");
    private final JfrStackTraceEpochData epochData0 = new JfrStackTraceEpochData();
    private final JfrStackTraceEpochData epochData1 = new JfrStackTraceEpochData();
    private int stackTraceDepth = 64;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JfrStackTraceRepository() {
    }

    public void setStackTraceDepth(int value) {
        this.stackTraceDepth = UninterruptibleUtils.Math.clamp(value, 1, 2048);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getStackTraceDepth() {
        return this.stackTraceDepth;
    }

    public void teardown() {
        this.epochData0.teardown();
        this.epochData1.teardown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverInline(value="Starting a stack walk in the caller frame.")
    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public long getStackTraceId(int skipCount) {
        if (DeoptimizationSupport.enabled()) {
            return 0L;
        }
        JfrExecutionSampler.singleton().preventSamplingInCurrentThread();
        try {
            SamplerSampleWriterData data = (SamplerSampleWriterData)StackValue.get(SamplerSampleWriterData.class);
            if (!SamplerSampleWriterDataAccess.initialize(data, skipCount, true)) {
                long l = 0L;
                return l;
            }
            assert (SamplerSampleWriterDataAccess.verify(data));
            assert (data.getCurrentPos().unsignedRemainder(8).equal(0));
            SamplerSampleWriter.begin(data);
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            CodePointer ip = FrameAccess.singleton().readReturnAddress(CurrentIsolate.getCurrentThread(), sp);
            int errorCode = JfrStackWalker.walkCurrentThread(data, ip, sp, false);
            long l = switch (errorCode) {
                case 0, 1 -> this.storeDeduplicatedStackTrace(data);
                case 3 -> 0L;
                case 2 -> throw VMError.shouldNotReachHere("Only the async sampler may encounter an unparseable stack.");
                default -> throw VMError.shouldNotReachHere("Unexpected return value");
            };
            return l;
        }
        finally {
            JfrExecutionSampler.singleton().allowSamplingInCurrentThread();
        }
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    private long storeDeduplicatedStackTrace(SamplerSampleWriterData data) {
        if (SamplerSampleWriter.isValid(data)) {
            Pointer start = data.getStartPos().add(SamplerSampleWriter.getHeaderSize());
            Pointer size = data.getCurrentPos().subtract((UnsignedWord)start);
            CIntPointer statusPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            JfrStackTraceTableEntry epochSpecificEntry = this.getOrPutStackTrace(start, (UnsignedWord)size, data.getHashCode(), statusPtr);
            if (epochSpecificEntry.isNonNull()) {
                if (statusPtr.read() == 1) {
                    boolean success = SamplerSampleWriter.end(data, -1L);
                    assert (success) : "must succeed because data was valid earlier";
                }
                return epochSpecificEntry.getId();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition and result is only valid until epoch changes.", callerMustBe=true)
    public JfrStackTraceTableEntry getOrPutStackTrace(Pointer start, UnsignedWord size, int hashCode, CIntPointer statusPtr) {
        this.mutex.lockNoTransition();
        try {
            JfrStackTraceTableEntry jfrStackTraceTableEntry = this.getOrPutStackTrace0(start, size, hashCode, statusPtr);
            return jfrStackTraceTableEntry;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Locking without transition and result is only valid until epoch changes.", callerMustBe=true)
    private JfrStackTraceTableEntry getOrPutStackTrace0(Pointer start, UnsignedWord size, int hashCode, CIntPointer statusPtr) {
        assert (size.rawValue() == (long)((int)size.rawValue()));
        JfrStackTraceTableEntry entry = (JfrStackTraceTableEntry)StackValue.get(JfrStackTraceTableEntry.class);
        entry.setHash(hashCode);
        entry.setSize((int)size.rawValue());
        entry.setRawStackTrace(start);
        entry.setSerialized(false);
        JfrStackTraceEpochData epochData = this.getEpochData(false);
        JfrStackTraceTableEntry result = (JfrStackTraceTableEntry)epochData.table.get(entry);
        if (result.isNonNull()) {
            int status = result.getSerialized() ? 4 : 2;
            statusPtr.write(status);
            return result;
        }
        Pointer to = (Pointer)NullableNativeMemory.malloc(size, NmtCategory.JFR);
        if (to.isNonNull()) {
            UnmanagedMemoryUtil.copy(start, to, size);
            entry.setRawStackTrace(to);
            JfrStackTraceTableEntry newEntry = (JfrStackTraceTableEntry)epochData.table.getOrPut(entry);
            if (newEntry.isNonNull()) {
                statusPtr.write(1);
                return newEntry;
            }
            NullableNativeMemory.free((PointerBase)to);
            to = (Pointer)Word.nullPointer();
        }
        statusPtr.write(8);
        return (JfrStackTraceTableEntry)Word.nullPointer();
    }

    @Uninterruptible(reason="Locking without transition and result is only valid until epoch changes.", callerMustBe=true)
    public void commitSerializedStackTrace(JfrStackTraceTableEntry entry) {
        this.mutex.lockNoTransition();
        try {
            entry.setSerialized(true);
            ++this.getEpochData((boolean)false).unflushedEntries;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public int write(JfrChunkWriter writer, boolean flushpoint) {
        if (flushpoint) {
            return 0;
        }
        this.mutex.lockNoTransition();
        try {
            JfrStackTraceEpochData epochData = this.getEpochData(!flushpoint);
            int count = epochData.unflushedEntries;
            if (count != 0) {
                writer.writeCompressedLong(JfrType.StackTrace.getId());
                writer.writeCompressedInt(count);
                writer.write(epochData.buffer);
            }
            epochData.clear(flushpoint);
            int n = count == 0 ? 0 : 1;
            return n;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    private JfrStackTraceEpochData getEpochData(boolean previousEpoch) {
        boolean epoch = previousEpoch ? JfrTraceIdEpoch.getInstance().previousEpoch() : JfrTraceIdEpoch.getInstance().currentEpoch();
        return epoch ? this.epochData0 : this.epochData1;
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public JfrBuffer getCurrentBuffer() {
        JfrStackTraceEpochData epochData = this.getEpochData(false);
        if (epochData.buffer.isNull()) {
            epochData.buffer = JfrBufferAccess.allocate(JfrBufferType.C_HEAP);
        }
        return epochData.buffer;
    }

    @Uninterruptible(reason="Prevent epoch change.", callerMustBe=true)
    public void setCurrentBuffer(JfrBuffer value) {
        this.getEpochData((boolean)false).buffer = value;
    }

    private static class JfrStackTraceEpochData {
        private final JfrStackTraceTable table = new JfrStackTraceTable();
        private int unflushedEntries = 0;
        private JfrBuffer buffer;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrStackTraceEpochData() {
        }

        @Uninterruptible(reason="May write current epoch data.")
        void clear(boolean flushpoint) {
            if (!flushpoint) {
                this.table.clear();
            }
            this.unflushedEntries = 0;
            JfrBufferAccess.reinitialize(this.buffer);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        void teardown() {
            this.table.teardown();
            this.unflushedEntries = 0;
            JfrBufferAccess.free(this.buffer);
            this.buffer = (JfrBuffer)Word.nullPointer();
        }
    }

    @RawStructure
    public static interface JfrStackTraceTableEntry
    extends JfrVisited {
        @RawField
        public Pointer getRawStackTrace();

        @RawField
        public void setRawStackTrace(Pointer var1);

        @RawField
        public int getSize();

        @RawField
        public void setSize(int var1);

        @RawField
        public boolean getSerialized();

        @RawField
        public void setSerialized(boolean var1);
    }

    public static class JfrStackTraceTableEntryStatus {
        public static final int INSERTED = 1;
        public static final int EXISTING_RAW = 2;
        public static final int EXISTING_SERIALIZED = 4;
        public static final int INSERT_FAILED = 8;
    }

    public static final class JfrStackTraceTable
    extends AbstractUninterruptibleHashtable {
        private static long nextId;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrStackTraceTable() {
            super(NmtCategory.JFR);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected JfrStackTraceTableEntry[] createTable(int size) {
            return new JfrStackTraceTableEntry[size];
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isEqual(UninterruptibleEntry a, UninterruptibleEntry b) {
            JfrStackTraceTableEntry entry1 = (JfrStackTraceTableEntry)a;
            JfrStackTraceTableEntry entry2 = (JfrStackTraceTableEntry)b;
            return entry1.getSize() == entry2.getSize() && LibC.memcmp(entry1.getRawStackTrace(), entry2.getRawStackTrace(), Word.unsigned((int)entry1.getSize())) == 0;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected UninterruptibleEntry copyToHeap(UninterruptibleEntry valueOnStack) {
            JfrStackTraceTableEntry result = (JfrStackTraceTableEntry)this.copyToHeap(valueOnStack, SizeOf.unsigned(JfrStackTraceTableEntry.class));
            if (result.isNonNull()) {
                result.setId(++nextId);
            }
            return result;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void free(UninterruptibleEntry entry) {
            JfrStackTraceTableEntry stackTraceEntry = (JfrStackTraceTableEntry)entry;
            NullableNativeMemory.free((PointerBase)stackTraceEntry.getRawStackTrace());
            super.free(entry);
        }
    }
}

