/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.compression.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CompressionUtils {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static byte[] intsToBytes(int[] data) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(data);
        return byteBuffer.array();
    }

    public static int[] bytesToInts(byte[] data) {
        IntBuffer intBuf = ByteBuffer.wrap(data).asIntBuffer();
        int[] array = new int[intBuf.remaining()];
        intBuf.get(array);
        return array;
    }

    public static int readInt(InputStream stream) throws IOException {
        return stream.read() << 24 | stream.read() << 16 | stream.read() << 8 | stream.read();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void writeInt(OutputStream stream, int value) throws IOException {
        stream.write((byte)(value >>> 24));
        stream.write((byte)(value >>> 16));
        stream.write((byte)(value >>> 8));
        stream.write((byte)value);
    }

    public static int readNBytes(InputStream input, byte[] dst) throws IOException {
        int remaining = dst.length;
        int offset = 0;
        int bytesRead = input.read(dst, 0, remaining);
        while (bytesRead > 0) {
            bytesRead = input.read(dst, offset += bytesRead, remaining -= bytesRead);
        }
        return offset;
    }
}

