/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.buildtimeinit;

import com.oracle.svm.core.FutureDefaultsOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JRTSupport;
import com.oracle.svm.core.jdk.buildtimeinit.FileSystemProviderBuildTimeInitSupport;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class FileSystemProviderBuildTimeInitFeature
implements InternalFeature {
    FileSystemProviderBuildTimeInitFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !FutureDefaultsOptions.fileSystemProvidersInitializedAtRunTime();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ArrayList<FileSystemProvider> installedProviders = new ArrayList<FileSystemProvider>();
        if (FileSystemProviderBuildTimeInitSupport.Options.AddAllFileSystemProviders.getValue().booleanValue()) {
            installedProviders.addAll(FileSystemProvider.installedProviders());
        }
        ImageSingletons.add(FileSystemProviderBuildTimeInitSupport.class, (Object)new FileSystemProviderBuildTimeInitSupport(installedProviders));
        if (!JRTSupport.Options.AllowJRTFileSystem.getValue().booleanValue()) {
            FileSystemProviderBuildTimeInitSupport.remove("jrt");
        }
    }
}

