/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import java.util.Objects;
import jdk.internal.util.StaticProperty;

@Substitute
@TargetClass(value=StaticProperty.class)
final class Target_jdk_internal_util_StaticProperty {
    @Delete
    private static String JAVA_HOME;
    @Delete
    private static String USER_HOME;
    @Delete
    private static String USER_DIR;
    @Delete
    private static String USER_NAME;
    @Delete
    private static String JAVA_LIBRARY_PATH;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String SUN_BOOT_LIBRARY_PATH;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String JDK_SERIAL_FILTER;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String JDK_SERIAL_FILTER_FACTORY;
    @Delete
    private static String JAVA_IO_TMPDIR;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String NATIVE_ENCODING;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String FILE_ENCODING;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String JAVA_PROPERTIES_DATE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String SUN_JNU_ENCODING;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String JAVA_LOCALE_USE_OLD_ISO_CODES;
    @Delete
    private static String OS_NAME;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String OS_ARCH;
    @Delete
    private static String OS_VERSION;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_LANGUAGE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_LANGUAGE_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_LANGUAGE_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_SCRIPT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_SCRIPT_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_SCRIPT_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_COUNTRY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_COUNTRY_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_COUNTRY_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_VARIANT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_VARIANT_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_VARIANT_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_EXTENSIONS;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_EXTENSIONS_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_EXTENSIONS_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public static String USER_REGION;
    static final /* synthetic */ boolean $assertionsDisabled;

    Target_jdk_internal_util_StaticProperty() {
    }

    @Substitute
    private static String javaHome() {
        return SystemPropertiesSupport.singleton().getInitialProperty("java.home");
    }

    @Substitute
    private static String userHome() {
        return SystemPropertiesSupport.singleton().getInitialProperty("user.home");
    }

    @Substitute
    private static String userDir() {
        return SystemPropertiesSupport.singleton().getInitialProperty("user.dir");
    }

    @Substitute
    private static String userName() {
        return SystemPropertiesSupport.singleton().getInitialProperty("user.name");
    }

    @Substitute
    private static String javaLibraryPath() {
        return SystemPropertiesSupport.singleton().getInitialProperty("java.library.path", "");
    }

    @Substitute
    private static String javaIoTmpDir() {
        return SystemPropertiesSupport.singleton().getInitialProperty("java.io.tmpdir");
    }

    @Substitute
    public static String sunBootLibraryPath() {
        if (!$assertionsDisabled && !Objects.equals(SUN_BOOT_LIBRARY_PATH, SystemPropertiesSupport.singleton().getInitialProperty("sun.boot.library.path", ""))) {
            throw new AssertionError();
        }
        return SUN_BOOT_LIBRARY_PATH;
    }

    @Substitute
    public static String jdkSerialFilter() {
        if (!$assertionsDisabled && !Objects.equals(JDK_SERIAL_FILTER, SystemPropertiesSupport.singleton().getInitialProperty("jdk.serialFilter"))) {
            throw new AssertionError();
        }
        return JDK_SERIAL_FILTER;
    }

    @Substitute
    public static String jdkSerialFilterFactory() {
        if (!$assertionsDisabled && !Objects.equals(JDK_SERIAL_FILTER_FACTORY, SystemPropertiesSupport.singleton().getInitialProperty("jdk.serialFilterFactory"))) {
            throw new AssertionError();
        }
        return JDK_SERIAL_FILTER_FACTORY;
    }

    @Substitute
    public static String nativeEncoding() {
        if (!$assertionsDisabled && !Objects.equals(NATIVE_ENCODING, SystemPropertiesSupport.singleton().getInitialProperty("native.encoding"))) {
            throw new AssertionError();
        }
        return NATIVE_ENCODING;
    }

    @Substitute
    public static String fileEncoding() {
        if (!$assertionsDisabled && !Objects.equals(FILE_ENCODING, SystemPropertiesSupport.singleton().getInitialProperty("file.encoding"))) {
            throw new AssertionError();
        }
        return FILE_ENCODING;
    }

    @Substitute
    public static String javaPropertiesDate() {
        if (!$assertionsDisabled && !Objects.equals(JAVA_PROPERTIES_DATE, SystemPropertiesSupport.singleton().getInitialProperty("java.properties.date"))) {
            throw new AssertionError();
        }
        return JAVA_PROPERTIES_DATE;
    }

    @Substitute
    public static String jnuEncoding() {
        if (!$assertionsDisabled && !Objects.equals(SUN_JNU_ENCODING, SystemPropertiesSupport.singleton().getInitialProperty("sun.jnu.encoding"))) {
            throw new AssertionError();
        }
        return SUN_JNU_ENCODING;
    }

    @Substitute
    public static String javaLocaleUseOldISOCodes() {
        if (!$assertionsDisabled && !Objects.equals(JAVA_LOCALE_USE_OLD_ISO_CODES, SystemPropertiesSupport.singleton().getInitialProperty("java.locale.useOldISOCodes", ""))) {
            throw new AssertionError();
        }
        return JAVA_LOCALE_USE_OLD_ISO_CODES;
    }

    @Substitute
    public static String osName() {
        return SystemPropertiesSupport.singleton().getInitialProperty("os.name");
    }

    @Substitute
    public static String osArch() {
        if (!$assertionsDisabled && !Objects.equals(OS_ARCH, SystemPropertiesSupport.singleton().getInitialProperty("os.arch"))) {
            throw new AssertionError();
        }
        return OS_ARCH;
    }

    @Substitute
    public static String osVersion() {
        return SystemPropertiesSupport.singleton().getInitialProperty("os.version");
    }

    static {
        boolean bl = $assertionsDisabled = !Target_jdk_internal_util_StaticProperty.class.desiredAssertionStatus();
        if (!SubstrateUtil.HOSTED) {
            SystemPropertiesSupport p = SystemPropertiesSupport.singleton();
            SUN_BOOT_LIBRARY_PATH = p.getInitialProperty("sun.boot.library.path", "");
            JDK_SERIAL_FILTER = p.getInitialProperty("jdk.serialFilter");
            JDK_SERIAL_FILTER_FACTORY = p.getInitialProperty("jdk.serialFilterFactory");
            NATIVE_ENCODING = p.getInitialProperty("native.encoding");
            FILE_ENCODING = p.getInitialProperty("file.encoding");
            JAVA_PROPERTIES_DATE = p.getInitialProperty("java.properties.date");
            SUN_JNU_ENCODING = p.getInitialProperty("sun.jnu.encoding");
            JAVA_LOCALE_USE_OLD_ISO_CODES = p.getInitialProperty("java.locale.useOldISOCodes", "");
            OS_ARCH = p.getInitialProperty("os.arch");
            USER_LANGUAGE = p.getInitialProperty("user.language", "en");
            USER_LANGUAGE_DISPLAY = p.getInitialProperty("user.language.display", USER_LANGUAGE);
            USER_LANGUAGE_FORMAT = p.getInitialProperty("user.language.format", USER_LANGUAGE);
            USER_REGION = p.getInitialProperty("user.region", "");
            if (!USER_REGION.isEmpty()) {
                int i = USER_REGION.indexOf(95);
                if (i >= 0) {
                    USER_COUNTRY = USER_REGION.substring(0, i);
                    USER_VARIANT = USER_REGION.substring(i + 1);
                } else {
                    USER_COUNTRY = USER_REGION;
                    USER_VARIANT = "";
                }
                USER_SCRIPT = "";
            } else {
                USER_SCRIPT = p.getInitialProperty("user.script", "");
                USER_COUNTRY = p.getInitialProperty("user.country", "");
                USER_VARIANT = p.getInitialProperty("user.variant", "");
            }
            USER_SCRIPT_DISPLAY = p.getInitialProperty("user.script.display", USER_SCRIPT);
            USER_SCRIPT_FORMAT = p.getInitialProperty("user.script.format", USER_SCRIPT);
            USER_COUNTRY_DISPLAY = p.getInitialProperty("user.country.display", USER_COUNTRY);
            USER_COUNTRY_FORMAT = p.getInitialProperty("user.country.format", USER_COUNTRY);
            USER_VARIANT_DISPLAY = p.getInitialProperty("user.variant.display", USER_VARIANT);
            USER_VARIANT_FORMAT = p.getInitialProperty("user.variant.format", USER_VARIANT);
            USER_EXTENSIONS = p.getInitialProperty("user.extensions", "");
            USER_EXTENSIONS_DISPLAY = p.getInitialProperty("user.extensions.display", USER_EXTENSIONS);
            USER_EXTENSIONS_FORMAT = p.getInitialProperty("user.extensions.format", USER_EXTENSIONS);
        }
    }
}

