/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.jdk.PrivilegedStack;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;

class StackAccessControlContextVisitor
extends JavaStackFrameVisitor {
    final ArrayList<ProtectionDomain> localArray = new ArrayList();
    boolean isPrivileged = false;
    ProtectionDomain previousProtectionDomain;
    AccessControlContext privilegedContext = null;

    StackAccessControlContextVisitor() {
    }

    @Override
    public boolean visitFrame(FrameSourceInfo frameSourceInfo) {
        ProtectionDomain protectionDomain;
        if (!StackTraceUtils.shouldShowFrame(frameSourceInfo, true, false, false)) {
            return true;
        }
        Class<?> clazz = frameSourceInfo.getSourceClass();
        String method = frameSourceInfo.getSourceMethodName();
        if (PrivilegedStack.length() > 0 && clazz.equals(AccessController.class) && method.equals("doPrivileged")) {
            this.isPrivileged = true;
            this.privilegedContext = PrivilegedStack.peekContext();
            protectionDomain = PrivilegedStack.peekCaller().getProtectionDomain();
        } else {
            protectionDomain = clazz.getProtectionDomain();
        }
        if (!(protectionDomain == null || this.previousProtectionDomain != null && this.previousProtectionDomain.equals(protectionDomain))) {
            this.localArray.add(protectionDomain);
            this.previousProtectionDomain = protectionDomain;
        }
        return !this.isPrivileged;
    }
}

