/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.sun.crypto.provider.SunJCE;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.security.provider.Sun;
import sun.security.rsa.SunRsaSign;
import sun.security.ssl.SunJSSE;
import sun.security.util.Debug;

public final class SecurityProvidersSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Set<String> markedAsNotLoaded = ConcurrentHashMap.newKeySet();
    private final EconomicSet<String> userRequestedSecurityProviders = EconomicSet.create();
    private final EconomicMap<String, Object> verifiedSecurityProviders = ImageHeapMap.create("verifiedSecurityProviders");
    private Properties savedInitialSecurityProperties;
    private Constructor<?> sunECConstructor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SecurityProvidersSupport(List<String> userRequestedSecurityProviders) {
        this.userRequestedSecurityProviders.addAll(userRequestedSecurityProviders);
    }

    @Fold
    public static SecurityProvidersSupport singleton() {
        return (SecurityProvidersSupport)ImageSingletons.lookup(SecurityProvidersSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addVerifiedSecurityProvider(String key, Object verificationResult) {
        this.verifiedSecurityProviders.put((Object)key, verificationResult);
    }

    public Object getSecurityProviderVerificationResult(String key) {
        return this.verifiedSecurityProviders.get((Object)key);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void markSecurityProviderAsNotLoaded(String provider) {
        this.markedAsNotLoaded.add(provider);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isSecurityProviderNotLoaded(String provider) {
        return this.markedAsNotLoaded.contains(provider);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isUserRequestedSecurityProvider(String provider) {
        return this.userRequestedSecurityProviders.contains((Object)provider);
    }

    public boolean isSecurityProviderRequested(String providerName, String providerFQName) {
        return this.verifiedSecurityProviders.containsKey((Object)providerName) || this.userRequestedSecurityProviders.contains((Object)providerFQName);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setSunECConstructor(Constructor<?> sunECConstructor) {
        this.sunECConstructor = sunECConstructor;
    }

    public Provider allocateSunECProvider() {
        try {
            return (Provider)this.sunECConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere("The SunEC constructor is not present.");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setSavedInitialSecurityProperties(Properties savedSecurityProperties) {
        this.savedInitialSecurityProperties = savedSecurityProperties;
    }

    public Properties getSavedInitialSecurityProperties() {
        return this.savedInitialSecurityProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Provider loadBuiltInProvider(String provName, Debug debug) {
        Provider provider;
        switch (provName) {
            case "SUN": 
            case "sun.security.provider.Sun": {
                Sun sun;
                if (!this.isSecurityProviderRequested("SUN", "sun.security.provider.Sun")) return null;
                Sun sun2 = new Sun();
                provider = sun = sun2;
                return provider;
            }
            case "SunRsaSign": 
            case "sun.security.rsa.SunRsaSign": {
                if (!this.isSecurityProviderRequested("SunRsaSign", "sun.security.rsa.SunRsaSign")) return null;
                SunRsaSign sunRsaSign = new SunRsaSign();
                SunRsaSign sunRsaSign2 = sunRsaSign;
                provider = sunRsaSign2;
                return provider;
            }
            case "SunJCE": 
            case "com.sun.crypto.provider.SunJCE": {
                if (!this.isSecurityProviderRequested("SunJCE", "com.sun.crypto.provider.SunJCE")) return null;
                SunJCE sunJCE = new SunJCE();
                SunJCE sunJCE2 = sunJCE;
                provider = sunJCE2;
                return provider;
            }
            case "SunJSSE": {
                if (!this.isSecurityProviderRequested("SunJSSE", "sun.security.ssl.SunJSSE")) return null;
                SunJSSE sunJSSE = new SunJSSE();
                SunJSSE sunJSSE2 = sunJSSE;
                provider = sunJSSE2;
                return provider;
            }
            case "SunEC": {
                if (!this.isSecurityProviderRequested("SunEC", "sun.security.ec.SunEC")) return null;
                Provider provider2 = this.allocateSunECProvider();
                Provider provider3 = provider2;
                provider = provider3;
                return provider;
            }
            case "Apple": 
            case "apple.security.AppleProvider": {
                try {
                    Class<?> c = Class.forName("apple.security.AppleProvider");
                    if (!Provider.class.isAssignableFrom(c)) return null;
                    Provider provider4 = (Provider)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    provider = provider4;
                    return provider;
                }
                catch (Exception ex) {
                    if (debug == null) return null;
                    debug.println("Error loading provider Apple");
                    ex.printStackTrace();
                }
                return null;
            }
            default: {
                Sun sun;
                provider = sun = null;
            }
        }
        return provider;
    }

    public static boolean isBuiltInProvider(String provName) {
        return switch (provName) {
            case "SUN", "sun.security.provider.Sun", "SunRsaSign", "sun.security.rsa.SunRsaSign", "SunJCE", "com.sun.crypto.provider.SunJCE", "SunJSSE", "SunEC", "Apple", "apple.security.AppleProvider" -> true;
            default -> false;
        };
    }
}

