/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.encoder.SymbolEncoder;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.RuntimeModuleSupport;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.CompressedGlobTrie;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobTrieNode;
import com.oracle.svm.core.jdk.resources.MissingResourceRegistrationUtils;
import com.oracle.svm.core.jdk.resources.ResourceExceptionEntry;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.GlobUtils;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.NativeImageResourcePathRepresentation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class Resources
implements MultiLayeredImageSingleton {
    private static final int INVALID_TIMESTAMP = -1;
    public static final char RESOURCES_INTERNAL_PATH_SEPARATOR = '/';
    private static final String RESOURCE_KEYS = "resourceKeys";
    private static final String RESOURCE_REGISTRATION_STATES = "resourceRegistrationStates";
    private static final String PATTERNS = "patterns";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private SymbolEncoder encoder;
    private final EconomicMap<ModuleResourceKey, ConditionalRuntimeValue<ResourceStorageEntryBase>> resources = ImageHeapMap.createNonLayeredMap();
    private final EconomicMap<RequestedPattern, RuntimeConditionSet> requestedPatterns = ImageHeapMap.createNonLayeredMap();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Map<String, Boolean> previousLayerResources;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Set<String> previousLayerPatterns;
    public static final ResourceStorageEntryBase NEGATIVE_QUERY_MARKER = new ResourceStorageEntryBase();
    private static final ResourceStorageEntryBase MISSING_METADATA_MARKER = new ResourceStorageEntryBase();
    private long lastModifiedTime = -1L;
    private GlobTrieNode<ClassLoaderSupport.ConditionWithOrigin> resourcesTrieRoot;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Function<Module, Module> hostedToRuntimeModuleMapper;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String BEGIN_ESCAPED_SEQUENCE = "\\Q";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String END_ESCAPED_SEQUENCE = "\\E";

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Resources currentLayer() {
        return LayeredImageSingletonSupport.singleton().lookup(Resources.class, false, true);
    }

    public static Resources[] layeredSingletons() {
        assert (!SubstrateUtil.HOSTED) : "Accessing all layers resources at build time";
        return (Resources[])MultiLayeredImageSingleton.getAllLayers(Resources.class);
    }

    Resources() {
        this(Map.of(), Set.of());
    }

    Resources(Map<String, Boolean> previousLayerResources, Set<String> previousLayerPatterns) {
        this.previousLayerResources = previousLayerResources;
        this.previousLayerPatterns = previousLayerPatterns;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setEncoder(SymbolEncoder encoder) {
        this.encoder = encoder;
    }

    public GlobTrieNode<ClassLoaderSupport.ConditionWithOrigin> getResourcesTrieRoot() {
        return this.resourcesTrieRoot;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setResourcesTrieRoot(GlobTrieNode<ClassLoaderSupport.ConditionWithOrigin> resourcesTrieRoot) {
        this.resourcesTrieRoot = resourcesTrieRoot;
    }

    public void forEachResource(BiConsumer<ModuleResourceKey, ConditionalRuntimeValue<ResourceStorageEntryBase>> action) {
        MapCursor entries = this.resources.getEntries();
        while (entries.advance()) {
            action.accept((ModuleResourceKey)entries.getKey(), (ConditionalRuntimeValue)entries.getValue());
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ConditionalRuntimeValue<ResourceStorageEntryBase> getResource(ModuleResourceKey storageKey) {
        return (ConditionalRuntimeValue)this.resources.get((Object)storageKey);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Iterable<ConditionalRuntimeValue<ResourceStorageEntryBase>> resources() {
        return this.resources.getValues();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Iterable<ModuleResourceKey> resourceKeys() {
        return this.resources.getKeys();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public int count() {
        return this.resources.size();
    }

    public static long getLastModifiedTime() {
        Resources[] singletons = Resources.layeredSingletons();
        return singletons[singletons.length - 1].lastModifiedTime;
    }

    public static String moduleName(Module module) {
        return module == null ? null : module.getName();
    }

    public static ModuleResourceKey createStorageKey(Module module, String resourceName) {
        Module m;
        Module module2 = m = module != null && module.isNamed() ? module : null;
        if (ImageInfo.inImageBuildtimeCode() && m != null) {
            m = Resources.currentLayer().hostedToRuntimeModuleMapper.apply(m);
        }
        return ImageLayerBuildingSupport.buildingImageLayer() ? new ModuleNameResourceKey(m, resourceName) : new ModuleInstanceResourceKey(m, resourceName);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setHostedToRuntimeModuleMapper(Function<Module, Module> hostedToRuntimeModuleMapper) {
        this.hostedToRuntimeModuleMapper = hostedToRuntimeModuleMapper;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Set<String> getIncludedResourcesModules() {
        return StreamSupport.stream(Resources.currentLayer().resources.getKeys().spliterator(), false).map(ModuleResourceKey::getModuleName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static byte[] inputStreamToByteArray(InputStream is) {
        try {
            return is.readAllBytes();
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void updateTimeStamp() {
        if (this.lastModifiedTime == -1L) {
            this.lastModifiedTime = new Date().getTime();
        }
    }

    private void addResource(ModuleResourceKey key, ConditionalRuntimeValue<ResourceStorageEntryBase> entry) {
        Boolean previousLayerData;
        Boolean bl = previousLayerData = ImageLayerBuildingSupport.buildingImageLayer() ? this.previousLayerResources.get(key.toString()) : null;
        if (previousLayerData == null || !previousLayerData.booleanValue() && entry.getValueUnconditionally() != NEGATIVE_QUERY_MARKER) {
            this.resources.put((Object)key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void addEntry(Module module, String resourceName, boolean isDirectory, byte[] data, boolean fromJar, boolean isNegativeQuery) {
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Trying to add a resource entry after analysis.");
        Module m = module != null && module.isNamed() ? module : null;
        EconomicMap<ModuleResourceKey, ConditionalRuntimeValue<ResourceStorageEntryBase>> economicMap = this.resources;
        synchronized (economicMap) {
            ModuleResourceKey key = Resources.createStorageKey(m, resourceName);
            RuntimeConditionSet conditionSet = RuntimeConditionSet.emptySet();
            ConditionalRuntimeValue<ResourceStorageEntryBase> entry = (ConditionalRuntimeValue<ResourceStorageEntryBase>)this.resources.get((Object)key);
            if (isNegativeQuery) {
                if (entry == null) {
                    this.addResource(key, new ConditionalRuntimeValue<ResourceStorageEntryBase>(conditionSet, NEGATIVE_QUERY_MARKER));
                }
                return;
            }
            if (entry == null || entry.getValueUnconditionally() == NEGATIVE_QUERY_MARKER) {
                this.updateTimeStamp();
                entry = new ConditionalRuntimeValue<ResourceStorageEntryBase>(conditionSet, new ResourceStorageEntry(isDirectory, fromJar));
                this.addResource(key, entry);
            } else if (key.module() != null) {
                return;
            }
            ((ResourceStorageEntryBase)entry.getValueUnconditionally()).addData(data);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(String resourceName, InputStream is) {
        Resources.currentLayer().registerResource(null, resourceName, is, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerResource(Module module, String resourceName, byte[] resourceContent) {
        this.addEntry(module, resourceName, false, resourceContent, true, false);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerResource(Module module, String resourceName, InputStream is, boolean fromJar) {
        this.addEntry(module, resourceName, false, Resources.inputStreamToByteArray(is), fromJar, false);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerDirectoryResource(Module module, String resourceDirName, String content, boolean fromJar) {
        this.addEntry(module, resourceDirName, true, content.getBytes(), fromJar, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerIOException(Module module, String resourceName, IOException e, boolean linkAtBuildTime) {
        if (linkAtBuildTime) {
            if (SubstrateOptions.ThrowLinkAtBuildTimeIOExceptions.getValue().booleanValue()) {
                throw new RuntimeException("Resource " + resourceName + " from module " + Resources.moduleName(module) + " produced an IOException.", e);
            }
            LogUtils.warning((String)("Resource " + resourceName + " from module " + Resources.moduleName(module) + " produced the following IOException: " + e.getClass().getTypeName() + ": " + e.getMessage()));
        }
        ModuleResourceKey key = Resources.createStorageKey(module, resourceName);
        EconomicMap<ModuleResourceKey, ConditionalRuntimeValue<ResourceStorageEntryBase>> economicMap = this.resources;
        synchronized (economicMap) {
            this.updateTimeStamp();
            this.addResource(key, new ConditionalRuntimeValue<ResourceStorageEntryBase>(RuntimeConditionSet.emptySet(), new ResourceExceptionEntry(e)));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerNegativeQuery(String resourceName) {
        this.registerNegativeQuery(null, resourceName);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerNegativeQuery(Module module, String resourceName) {
        this.addEntry(module, resourceName, false, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerIncludePattern(ConfigurationCondition condition, String module, String pattern) {
        assert (MissingRegistrationUtils.throwMissingRegistrationErrors());
        EconomicMap<RequestedPattern, RuntimeConditionSet> economicMap = this.requestedPatterns;
        synchronized (economicMap) {
            this.updateTimeStamp();
            this.addPattern(new RequestedPattern(this.encoder.encodeModule(module), Resources.handleEscapedCharacters(pattern)), RuntimeConditionSet.createHosted(condition));
        }
    }

    private void addPattern(RequestedPattern pattern, RuntimeConditionSet condition) {
        if (!this.previousLayerPatterns.contains(pattern.toString())) {
            this.requestedPatterns.put((Object)pattern, (Object)condition);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String handleEscapedCharacters(String pattern) {
        if (pattern.startsWith(BEGIN_ESCAPED_SEQUENCE) && pattern.endsWith(END_ESCAPED_SEQUENCE)) {
            return pattern.substring(BEGIN_ESCAPED_SEQUENCE.length(), pattern.length() - END_ESCAPED_SEQUENCE.length());
        }
        return pattern;
    }

    private static boolean hasTrailingSlash(String resourceName) {
        return resourceName.endsWith("/");
    }

    private static String removeTrailingSlash(String resourceName) {
        return Resources.hasTrailingSlash(resourceName) ? resourceName.substring(0, resourceName.length() - 1) : resourceName;
    }

    private static boolean wasAlreadyInCanonicalForm(String resourceName, String canonicalResourceName) {
        return resourceName.equals(canonicalResourceName) || Resources.removeTrailingSlash(resourceName).equals(canonicalResourceName);
    }

    public static ResourceStorageEntryBase getAtRuntime(String name) {
        return Resources.getAtRuntime(null, name, false);
    }

    public static ResourceStorageEntryBase getAtRuntime(Module module, String resourceName, boolean probe) {
        VMError.guarantee(ImageInfo.inImageRuntimeCode(), "This function should be used only at runtime.");
        String canonicalResourceName = NativeImageResourcePathRepresentation.toCanonicalForm((String)resourceName);
        String moduleName = Resources.moduleName(module);
        ConditionalRuntimeValue<ResourceStorageEntryBase> entry = Resources.getEntry(module, canonicalResourceName);
        if (entry == null) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                if (Resources.missingResourceMatchesIncludePattern(resourceName, moduleName) || Resources.missingResourceMatchesIncludePattern(canonicalResourceName, moduleName)) {
                    Resources.traceResource(resourceName, moduleName);
                    return null;
                }
                Resources.traceResourceMissingMetadata(resourceName, moduleName, probe);
                return Resources.missingMetadata(module, resourceName, probe);
            }
            Resources.traceResourceMissingMetadata(resourceName, moduleName, probe);
            return null;
        }
        Resources.traceResource(resourceName, moduleName);
        if (!entry.getConditions().satisfied()) {
            return Resources.missingMetadata(module, resourceName, probe);
        }
        ResourceStorageEntryBase unconditionalEntry = entry.getValue();
        assert (unconditionalEntry != null) : "Already checked above that the condition is satisfied";
        if (unconditionalEntry.isException()) {
            throw new RuntimeException(unconditionalEntry.getException());
        }
        if (unconditionalEntry == NEGATIVE_QUERY_MARKER) {
            return null;
        }
        if (unconditionalEntry.isFromJar() && !Resources.wasAlreadyInCanonicalForm(resourceName, canonicalResourceName)) {
            return null;
        }
        if (!unconditionalEntry.isDirectory() && Resources.hasTrailingSlash(resourceName)) {
            return null;
        }
        return unconditionalEntry;
    }

    @AlwaysInline(value="tracing should fold away when disabled")
    private static void traceResource(String resourceName, String moduleName) {
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceResource(resourceName, moduleName);
        }
    }

    @AlwaysInline(value="tracing should fold away when disabled")
    private static void traceResourceMissingMetadata(String resourceName, String moduleName) {
        Resources.traceResourceMissingMetadata(resourceName, moduleName, false);
    }

    @AlwaysInline(value="tracing should fold away when disabled")
    private static void traceResourceMissingMetadata(String resourceName, String moduleName, boolean probe) {
        if (MetadataTracer.enabled() && !probe) {
            MetadataTracer.singleton().traceResource(resourceName, moduleName);
        }
    }

    private static boolean missingResourceMatchesIncludePattern(String resourceName, String moduleName) {
        VMError.guarantee(MissingRegistrationUtils.throwMissingRegistrationErrors(), "include patterns are only stored in the image with exact reachability metadata");
        String glob = GlobUtils.transformToTriePath((String)resourceName, (String)moduleName);
        for (Resources r : Resources.layeredSingletons()) {
            MapCursor cursor = r.requestedPatterns.getEntries();
            while (cursor.advance()) {
                RequestedPattern moduleResourcePair = (RequestedPattern)cursor.getKey();
                if (!Objects.equals(moduleName, moduleResourcePair.module) || !Resources.matchResource(moduleResourcePair.resource, resourceName) || !((RuntimeConditionSet)cursor.getValue()).satisfied()) continue;
                return true;
            }
            if (!CompressedGlobTrie.match(r.getResourcesTrieRoot(), glob)) continue;
            return true;
        }
        return false;
    }

    private static ConditionalRuntimeValue<ResourceStorageEntryBase> getEntry(Module module, String canonicalResourceName) {
        for (Resources r : Resources.layeredSingletons()) {
            ConditionalRuntimeValue entry = (ConditionalRuntimeValue)r.resources.get((Object)Resources.createStorageKey(module, canonicalResourceName));
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    private static ResourceStorageEntryBase missingMetadata(Module module, String resourceName, boolean probe) {
        if (!probe) {
            MissingResourceRegistrationUtils.reportResourceAccess(module, resourceName);
        }
        return MISSING_METADATA_MARKER;
    }

    private static URL createURL(Module module, String resourceName, int index) {
        try {
            String refPart = index != 0 ? "#" + Integer.toString(index) : "";
            String moduleName = Resources.moduleName(module);
            return new URL("resource", moduleName, -1, "/" + resourceName + refPart);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static URL createURL(String resourceName) {
        return Resources.createURL(null, resourceName);
    }

    public static URL createURL(Module module, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Enumeration<URL> urls = Resources.createURLs(module, resourceName);
        return urls.hasMoreElements() ? urls.nextElement() : null;
    }

    public static InputStream createInputStream(Module module, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ResourceStorageEntryBase entry = Resources.findResourceForInputStream(module, resourceName);
        if (entry == MISSING_METADATA_MARKER) {
            Resources.traceResourceMissingMetadata(resourceName, Resources.moduleName(module));
            MissingResourceRegistrationUtils.reportResourceAccess(module, resourceName);
            return null;
        }
        if (entry == null) {
            return null;
        }
        List<byte[]> data = entry.getData();
        return data.isEmpty() ? null : new ByteArrayInputStream(data.get(0));
    }

    private static ResourceStorageEntryBase findResourceForInputStream(Module module, String resourceName) {
        ResourceStorageEntryBase result = Resources.getAtRuntime(module, resourceName, true);
        if (Resources.moduleName(module) == null && (result == MISSING_METADATA_MARKER || result == null)) {
            for (Module m : RuntimeModuleSupport.singleton().getBootLayer().modules()) {
                ResourceStorageEntryBase entry = Resources.getAtRuntime(m, resourceName, true);
                if (entry == MISSING_METADATA_MARKER) continue;
                if (entry != null) {
                    return entry;
                }
                result = null;
            }
        }
        return result;
    }

    public static Enumeration<URL> createURLs(String resourceName) {
        return Resources.createURLs(null, resourceName);
    }

    public static Enumeration<URL> createURLs(Module module, String resourceName) {
        ResourceStorageEntryBase explicitEntry;
        if (resourceName == null) {
            return null;
        }
        boolean missingMetadata = true;
        ArrayList<URL> resourcesURLs = new ArrayList<URL>();
        Object canonicalResourceName = NativeImageResourcePathRepresentation.toCanonicalForm((String)resourceName);
        if (Resources.hasTrailingSlash(resourceName)) {
            canonicalResourceName = (String)canonicalResourceName + "/";
        }
        if (Resources.moduleName(module) == null) {
            for (Module m : RuntimeModuleSupport.singleton().getBootLayer().modules()) {
                ResourceStorageEntryBase entry = Resources.getAtRuntime(m, resourceName, true);
                if (entry == MISSING_METADATA_MARKER) continue;
                missingMetadata = false;
                Resources.addURLEntries(resourcesURLs, (ResourceStorageEntry)entry, m, (String)canonicalResourceName);
            }
        }
        if ((explicitEntry = Resources.getAtRuntime(module, resourceName, true)) != MISSING_METADATA_MARKER) {
            missingMetadata = false;
            Resources.addURLEntries(resourcesURLs, (ResourceStorageEntry)explicitEntry, module, (String)canonicalResourceName);
        }
        if (missingMetadata) {
            MissingResourceRegistrationUtils.reportResourceAccess(module, resourceName);
        }
        if (resourcesURLs.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(resourcesURLs);
    }

    private static void addURLEntries(List<URL> resourcesURLs, ResourceStorageEntry entry, Module module, String canonicalResourceName) {
        if (entry == null) {
            return;
        }
        int numberOfResources = entry.getData().size();
        for (int index = 0; index < numberOfResources; ++index) {
            resourcesURLs.add(Resources.createURL(module, canonicalResourceName, index));
        }
    }

    private static boolean matchResource(String pattern, String resource) {
        int i;
        if (pattern.equals(resource)) {
            return true;
        }
        if (!pattern.contains("*")) {
            return false;
        }
        if (pattern.endsWith("*")) {
            return resource.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        String[] parts = pattern.split("\\*");
        boolean found = false;
        for (i = parts.length - 1; i > 0 && !found; --i) {
            found = !parts[i - 1].endsWith("\\");
        }
        if (!found) {
            return false;
        }
        String start = String.join((CharSequence)"*", Arrays.copyOfRange(parts, 0, i + 1));
        String end = String.join((CharSequence)"*", Arrays.copyOfRange(parts, i + 1, parts.length));
        return resource.startsWith(start) && resource.endsWith(end);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        ArrayList<String> resourceKeys = new ArrayList<String>();
        ArrayList<Boolean> resourceRegistrationStates = new ArrayList<Boolean>();
        HashSet<String> patterns = new HashSet<String>(this.previousLayerPatterns);
        MapCursor cursor = this.resources.getEntries();
        while (cursor.advance()) {
            resourceKeys.add(((ModuleResourceKey)cursor.getKey()).toString());
            boolean isNegativeQuery = ((ConditionalRuntimeValue)cursor.getValue()).getValueUnconditionally() == NEGATIVE_QUERY_MARKER;
            resourceRegistrationStates.add(!isNegativeQuery);
        }
        for (Map.Entry<String, Boolean> entry : this.previousLayerResources.entrySet()) {
            if (resourceKeys.contains(entry.getKey())) continue;
            resourceKeys.add(entry.getKey());
            resourceRegistrationStates.add(entry.getValue());
        }
        this.requestedPatterns.getKeys().forEach(p -> patterns.add(p.toString()));
        writer.writeStringList(RESOURCE_KEYS, resourceKeys);
        writer.writeBoolList(RESOURCE_REGISTRATION_STATES, resourceRegistrationStates);
        writer.writeStringList(PATTERNS, patterns.stream().toList());
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        List<String> previousLayerResourceKeys = loader.readStringList(RESOURCE_KEYS);
        List<Boolean> previousLayerRegistrationStates = loader.readBoolList(RESOURCE_REGISTRATION_STATES);
        HashMap<String, Boolean> previousLayerResources = new HashMap<String, Boolean>();
        for (int i = 0; i < previousLayerResourceKeys.size(); ++i) {
            previousLayerResources.put(previousLayerResourceKeys.get(i), previousLayerRegistrationStates.get(i));
        }
        Set<String> previousLayerPatterns = Set.copyOf(loader.readStringList(PATTERNS));
        return new Resources(Collections.unmodifiableMap(previousLayerResources), previousLayerPatterns);
    }

    public static interface ModuleResourceKey {
        public Module getModule();

        public String getModuleName();

        public Object module();

        public String resource();
    }

    public record ModuleNameResourceKey(Object module, String resource) implements ModuleResourceKey
    {
        public ModuleNameResourceKey(Object module, String resource) {
            assert (module == null || module instanceof Module) : "The ModuleNameResourceKey constructor should only be called with a Module as first argument";
            assert (ImageLayerBuildingSupport.buildingImageLayer()) : "The ModuleNameResourceKey should only be used in layered images.";
            this.module = module = module != null ? ((Module)module).getName() : module;
            this.resource = resource;
        }

        @Override
        public Module getModule() {
            throw VMError.shouldNotReachHere("Accessing the module instance of the ModuleResourceKey is not supported in layered images.");
        }

        @Override
        public String getModuleName() {
            return (String)this.module;
        }
    }

    public static final class ModuleInstanceResourceKey
    extends Record
    implements ModuleResourceKey {
        private final Module module;
        private final String resource;

        public ModuleInstanceResourceKey(Module module, String resource) {
            assert (!ImageLayerBuildingSupport.buildingImageLayer()) : "The ModuleInstanceResourceKey should only be used in standalone images.";
            this.module = module;
            this.resource = resource;
        }

        @Override
        public Module getModule() {
            return this.module;
        }

        @Override
        public String getModuleName() {
            if (this.module == null) {
                return null;
            }
            return this.module.getName();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ModuleInstanceResourceKey.class, "module;resource", "module", "resource"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ModuleInstanceResourceKey.class, "module;resource", "module", "resource"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ModuleInstanceResourceKey.class, "module;resource", "module", "resource"}, this, o);
        }

        @Override
        public Module module() {
            return this.module;
        }

        @Override
        public String resource() {
            return this.resource;
        }
    }

    public record RequestedPattern(String module, String resource) {
    }
}

