/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.TimeUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

public abstract class RandomAccessors {
    private static final boolean SECURE_SEED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("java.util.secureRandomSeed");
        }
    });
    protected volatile AtomicLong seeder;

    protected AtomicLong getOrInitializeSeeder() {
        AtomicLong result = this.seeder;
        if (result == null) {
            result = this.initialize();
        }
        return result;
    }

    private synchronized AtomicLong initialize() {
        long seed;
        AtomicLong result = this.seeder;
        if (result != null) {
            return result;
        }
        if (SECURE_SEED) {
            byte[] seedBytes = SecureRandom.getSeed(8);
            seed = (long)seedBytes[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                seed = seed << 8 | (long)seedBytes[i] & 0xFFL;
            }
        } else {
            seed = this.mix64(TimeUtils.currentTimeMillis()) ^ this.mix64(System.nanoTime());
        }
        this.seeder = result = new AtomicLong(seed);
        return result;
    }

    abstract long mix64(long var1);
}

