/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.identityhashcode.SubstrateIdentityHashCodeSnippets;

@AutomaticallyRegisteredFeature
final class SubstrateIdentityHashCodeFeature
implements InternalFeature {
    SubstrateIdentityHashCodeFeature() {
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (ol.isIdentityHashFieldOptional()) {
            foreignCalls.register(SubstrateIdentityHashCodeSnippets.COMPUTE_ABSENT_IDENTITY_HASH_CODE);
        } else {
            foreignCalls.register(SubstrateIdentityHashCodeSnippets.GENERATE_IDENTITY_HASH_CODE);
        }
    }
}

