/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.identityhashcode.SubstrateIdentityHashCodeSnippets;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import java.util.SplittableRandom;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;

public final class IdentityHashCodeSupport {
    public static final LocationIdentity IDENTITY_HASHCODE_LOCATION = NamedLocationIdentity.mutable((String)"identityHashCode");
    public static final LocationIdentity IDENTITY_HASHCODE_SALT_LOCATION = NamedLocationIdentity.mutable((String)"identityHashCodeSalt");
    private static final FastThreadLocalObject<SplittableRandom> hashCodeGeneratorTL = FastThreadLocalFactory.createObject(SplittableRandom.class, "IdentityHashCodeSupport.hashCodeGeneratorTL");

    public static void ensureInitialized() {
        new SplittableRandom().nextInt();
    }

    public static IdentityHashCodeSnippets.Templates createSnippetTemplates(OptionValues options, Providers providers) {
        return SubstrateIdentityHashCodeSnippets.createTemplates(options, providers);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.")
    public static int computeAbsentIdentityHashCode(Object obj) {
        Word objPtr;
        Word header;
        assert (ConfigurationValues.getObjectLayout().isIdentityHashFieldOptional());
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        if (oh.hasOptionalIdentityHashField(header = oh.readHeaderFromPointer((Pointer)(objPtr = Word.objectToUntrackedPointer((Object)obj))))) {
            return IdentityHashCodeSupport.readIdentityHashCodeFromField(obj);
        }
        if (!oh.hasIdentityHashFromAddress(header)) {
            oh.setIdentityHashFromAddress((Pointer)objPtr, header);
        }
        return IdentityHashCodeSupport.computeHashCodeFromAddress(obj);
    }

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.")
    public static int computeHashCodeFromAddress(Object obj) {
        Word address = Word.objectToUntrackedPointer((Object)obj);
        long salt = Heap.getHeap().getIdentityHashSalt(obj);
        SignedWord salted = Word.signed((long)salt).xor((SignedWord)address);
        int hash = IdentityHashCodeSupport.mix32(salted.rawValue()) >>> 1;
        return hash == 0 ? 1 : hash;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int mix32(long a) {
        long z = a;
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    public static int generateRandomHashCode() {
        SplittableRandom hashCodeGenerator = hashCodeGeneratorTL.get();
        if (hashCodeGenerator == null) {
            hashCodeGenerator = new SplittableRandom();
            hashCodeGeneratorTL.set(hashCodeGenerator);
        }
        int hashCode = hashCodeGenerator.nextInt(Integer.MAX_VALUE) + 1;
        assert (hashCode != 0) : "Must not return 0 because it means 'hash code not computed yet' in the field that stores the hash code";
        assert (hashCode > 0) : "The Java HotSpot VM only returns positive numbers for the identity hash code, so we want to have the same restriction on Substrate VM in order to not surprise users";
        return hashCode;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readIdentityHashCodeFromField(Object obj) {
        IdentityHashCodeSupport.assertHasIdentityHashField(obj);
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        int numBits = ol.getIdentityHashCodeNumBits();
        int shift = ol.getIdentityHashCodeShift();
        int offset = LayoutEncoding.getIdentityHashOffset(obj);
        int totalBits = numBits + shift;
        if (totalBits <= 32) {
            int value = ObjectAccess.readInt((Object)obj, (int)offset, (LocationIdentity)IDENTITY_HASHCODE_LOCATION);
            return IdentityHashCodeSupport.extractIdentityHashCode(value, numBits, shift);
        }
        long value = ObjectAccess.readLong((Object)obj, (int)offset, (LocationIdentity)IDENTITY_HASHCODE_LOCATION);
        return IdentityHashCodeSupport.extractIdentityHashCode(value, numBits, shift);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static int generateIdentityHashCode(Object obj) {
        VMError.guarantee(obj != null);
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        assert (!ol.isIdentityHashFieldOptional());
        int numBits = ol.getIdentityHashCodeNumBits();
        int shift = ol.getIdentityHashCodeShift();
        int offset = LayoutEncoding.getIdentityHashOffset(obj);
        int newHash = IdentityHashCodeSupport.generateRandomHashCode();
        int totalBits = numBits + shift;
        if (numBits == 32 && shift == 0) {
            if (!Unsafe.getUnsafe().compareAndSetInt(obj, offset, 0, newHash)) {
                return ObjectAccess.readInt((Object)obj, (int)offset, (LocationIdentity)IDENTITY_HASHCODE_LOCATION);
            }
        } else if (totalBits <= 32) {
            int newValue;
            int existingValue;
            do {
                int existingHash;
                if ((existingHash = IdentityHashCodeSupport.extractIdentityHashCode(existingValue = Unsafe.getUnsafe().getIntOpaque(obj, offset), numBits, shift)) != 0) {
                    return existingHash;
                }
                newValue = IdentityHashCodeSupport.encodeIdentityHashCode(existingValue, newHash, shift);
            } while (!Unsafe.getUnsafe().compareAndSetInt(obj, offset, existingValue, newValue));
        } else {
            long newValue;
            long existingValue;
            assert (totalBits <= 64);
            do {
                int existingHash;
                if ((existingHash = IdentityHashCodeSupport.extractIdentityHashCode(existingValue = Unsafe.getUnsafe().getLongOpaque(obj, offset), numBits, shift)) != 0) {
                    return existingHash;
                }
                newValue = IdentityHashCodeSupport.encodeIdentityHashCode(existingValue, (long)newHash, shift);
            } while (!Unsafe.getUnsafe().compareAndSetLong(obj, offset, existingValue, newValue));
        }
        assert (IdentityHashCodeSupport.readIdentityHashCodeFromField(obj) == newHash);
        return newHash;
    }

    public static void writeIdentityHashCodeToImageHeap(Pointer hashCodePtr, int value) {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        int numBits = ol.getIdentityHashCodeNumBits();
        int shift = ol.getIdentityHashCodeShift();
        long mask = ol.getIdentityHashCodeMask();
        int totalBits = numBits + shift;
        if (totalBits <= 32) {
            int oldValue = hashCodePtr.readInt(0);
            IdentityHashCodeSupport.assertIdentityHashCodeZero(oldValue, mask);
            hashCodePtr.writeInt(0, IdentityHashCodeSupport.encodeIdentityHashCode(oldValue, value, shift));
        } else {
            assert (totalBits <= 64);
            long oldValue = hashCodePtr.readLong(0);
            IdentityHashCodeSupport.assertIdentityHashCodeZero(oldValue, mask);
            hashCodePtr.writeLong(0, IdentityHashCodeSupport.encodeIdentityHashCode(oldValue, (long)value, shift));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int extractIdentityHashCode(int value, int numBits, int shift) {
        int left = 32 - numBits - shift;
        int right = 32 - numBits;
        return value << left >>> right;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int extractIdentityHashCode(long value, int numBits, int shift) {
        int left = 64 - numBits - shift;
        int right = 64 - numBits;
        return (int)(value << left >>> right);
    }

    private static int encodeIdentityHashCode(int existingValue, int newHash, int shift) {
        return existingValue | newHash << shift;
    }

    private static long encodeIdentityHashCode(long existingValue, long newHash, int shift) {
        return existingValue | newHash << shift;
    }

    private static void assertIdentityHashCodeZero(int oldValue, long mask) {
        assert (((long)oldValue & mask) == 0L) : "hashcode bits must be 0";
    }

    private static void assertIdentityHashCodeZero(long oldValue, long mask) {
        assert ((oldValue & mask) == 0L) : "hashcode bits must be 0";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void assertHasIdentityHashField(Object obj) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)IdentityHashCodeSupport.hasIdentityHashField(obj), (String)"must have an identity hashcode field");
        } else assert (IdentityHashCodeSupport.hasIdentityHashField(obj)) : "must have an identity hashcode field";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean hasIdentityHashField(Object obj) {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        return !ol.isIdentityHashFieldOptional() || oh.hasOptionalIdentityHashField(oh.readHeaderFromObject(obj));
    }
}

